/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IObjectTypeCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalMappingStrategy
extends AbstractMappingStrategy {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalMappingStrategy.class);
    private IObjectTypeCache objectTypeCache;

    @Override
    public CDOClassifierRef readObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeCache.getObjectType(accessor, id);
    }

    public void putObjectType(IDBStoreAccessor accessor, CDOID id, EClass type) {
        this.objectTypeCache.putObjectType(accessor, id, type);
    }

    @Override
    public long repairAfterCrash(IDBAdapter dbAdapter, Connection connection) {
        return this.objectTypeCache.getMaxId(connection) + 1L;
    }

    @Override
    protected Collection<EClass> getClassesWithObjectInfo() {
        return this.getClassMappings().keySet();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.objectTypeCache == null) {
            this.objectTypeCache = this.createObjectTypeCache();
            LifecycleUtil.activate((Object)this.objectTypeCache);
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.objectTypeCache);
        this.objectTypeCache = null;
        super.doDeactivate();
    }

    private IObjectTypeCache createObjectTypeCache() {
        ObjectTypeCache cache = new ObjectTypeCache();
        cache.setMappingStrategy(this);
        return cache;
    }

    @Override
    public void queryResources(IDBStoreAccessor dbStoreAccessor, IStoreAccessor.QueryResourcesContext context) {
        if (context.getTimeStamp() != 0L && !this.hasAuditSupport()) {
            throw new UnsupportedOperationException("Mapping Strategy does not support audits.");
        }
        EresourcePackage resourcesPackage = EresourcePackage.eINSTANCE;
        boolean shallContinue = this.queryResources(dbStoreAccessor, this.getClassMapping(resourcesPackage.getCDOResourceFolder()), context);
        if (shallContinue) {
            this.queryResources(dbStoreAccessor, this.getClassMapping(resourcesPackage.getCDOResource()), context);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean queryResources(IDBStoreAccessor accessor, IClassMapping classMapping, IStoreAccessor.QueryResourcesContext context) {
        stmt = null;
        rset = null;
        folderID = context.getFolderID();
        name = context.getName();
        exactMatch = context.exactMatch();
        timeStamp = context.getTimeStamp();
        try {
            stmt = classMapping.createResourceQueryStatement(accessor, folderID, name, exactMatch, timeStamp);
            rset = stmt.executeQuery();
            ** GOTO lbl-1000
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable var14_13) {
                DBUtil.close(rset);
                accessor.getStatementCache().releasePreparedStatement(stmt);
                throw var14_13;
            }
        }
lbl19:
        // 1 sources

        while (true) {
            DBUtil.close((ResultSet)rset);
            accessor.getStatementCache().releasePreparedStatement(stmt);
            return false;
        }
lbl-1000:
        // 2 sources

        {
            ** while (rset.next())
        }
lbl-1000:
        // 1 sources

        {
            longID = rset.getLong(1);
            if (AbstractHorizontalMappingStrategy.TRACER.isEnabled()) {
                AbstractHorizontalMappingStrategy.TRACER.format("Resource Query returned ID {0}", new Object[]{longID});
            }
            if (context.addResource(id = CDOIDUtil.createLong((long)longID))) continue;
            ** continue;
lbl30:
            // 1 sources

            ** GOTO lbl19
        }
lbl31:
        // 1 sources

        DBUtil.close((ResultSet)rset);
        accessor.getStatementCache().releasePreparedStatement(stmt);
        return true;
    }
}

