/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class GetRemoteSessionsIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, GetRemoteSessionsIndication.class);
    private boolean subscribe;

    public GetRemoteSessionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)28);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.subscribe = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read subscribe: {0}", new Object[]{this.subscribe});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        Session[] sessions;
        Session localSession = this.getSession();
        Session[] sessionArray = sessions = this.getSession().getSessionManager().getSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            Session session = sessionArray[n2];
            if (session != localSession) {
                out.writeInt(session.getSessionID());
                out.writeString(session.getUserID());
                out.writeBoolean(session.isSubscribed());
            }
            ++n2;
        }
        out.writeInt(-1);
        localSession.setSubscribed(this.subscribe);
    }
}

