/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOURIHandler
implements URIHandler {
    private static final String CDO_URI_SCHEME = "cdo";
    private InternalCDOView view;

    public CDOURIHandler(InternalCDOView view) {
        this.view = view;
    }

    public InternalCDOView getView() {
        return this.view;
    }

    public boolean canHandle(URI uri) {
        return CDO_URI_SCHEME.equals(uri.scheme()) && this.view.getSession().repository().getUUID().equals(CDOURIUtil.extractRepositoryUUID(uri));
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.view.hasResource(CDOURIUtil.extractResourcePath(uri));
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        String path = CDOURIUtil.extractResourcePath(uri);
        CDOTransaction transaction = null;
        try {
            try {
                transaction = this.view.getSession().openTransaction();
                CDOResourceNode node = transaction.getResourceNode(path);
                node.delete(options);
                transaction.commit();
            }
            catch (Exception ex) {
                IOException ioException = new IOException(ex.getMessage());
                ioException.initCause(ex);
                throw ioException;
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(transaction);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)transaction);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("CDOURIHandler.createInputStream() not implemented");
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("CDOURIHandler.createOutputStream() not implemented");
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return ContentHandler.INVALID_CONTENT_DESCRIPTION;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        String path = CDOURIUtil.extractResourcePath(uri);
        CDOResourceNode node = this.view.getResourceNode(path);
        if (node != null) {
            Set requestedAttributes = (Set)options.get("requestedAttributes");
            if (requestedAttributes == null || requestedAttributes.contains("timeStamp")) {
                long stamp = node instanceof CDOResource ? ((CDOResource)node).getTimeStamp() : -1L;
                result.put("timeStamp", Long.valueOf(stamp));
            }
            if (requestedAttributes == null || requestedAttributes.contains("directory")) {
                result.put("directory", Boolean.valueOf(node instanceof CDOResourceFolder));
            }
            if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
                result.put("readOnly", Boolean.valueOf(this.view.getViewType() != CDOCommonView.Type.TRANSACTION));
            }
        }
        return result;
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }
}

