/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.match.EMFCompareMatchMessages;
import org.eclipse.emf.compare.match.engine.GenericMatchEngine;
import org.eclipse.emf.compare.match.engine.IMatchEngine;
import org.eclipse.emf.compare.match.service.MatchEngineDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchEngineRegistry
extends HashMap<String, List<Object>> {
    public static final MatchEngineRegistry INSTANCE = new MatchEngineRegistry();
    private static final String ALL_EXTENSIONS = "*";
    private static final String MATCH_ENGINES_EXTENSION_POINT = "org.eclipse.emf.compare.match.engine";
    private static final long serialVersionUID = 2237008034183610765L;
    private static final String TAG_ENGINE = "matchengine";

    private MatchEngineRegistry() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.parseExtensionMetadata();
        } else {
            this.putValue(ALL_EXTENSIONS, new GenericMatchEngine());
        }
    }

    public List<MatchEngineDescriptor> getDescriptors(String fileExtension) {
        List specific = (List)this.get(fileExtension);
        ArrayList candidates = new ArrayList((Collection)this.get(ALL_EXTENSIONS));
        if (specific != null) {
            candidates.addAll(0, specific);
        }
        ArrayList<MatchEngineDescriptor> engines = new ArrayList<MatchEngineDescriptor>(candidates.size());
        for (Object value : candidates) {
            if (!(value instanceof MatchEngineDescriptor)) continue;
            engines.add((MatchEngineDescriptor)value);
        }
        return engines;
    }

    public IMatchEngine getHighestEngine(String fileExtension) {
        MatchEngineDescriptor desc;
        List engines = (List)this.get(fileExtension);
        int highestPriority = -1;
        IMatchEngine highest = null;
        if (engines != null) {
            for (Object engine : engines) {
                if (engine instanceof MatchEngineDescriptor) {
                    desc = (MatchEngineDescriptor)engine;
                    if (desc.getPriorityValue() <= highestPriority) continue;
                    highest = desc.getEngineInstance();
                    highestPriority = desc.getPriorityValue();
                    continue;
                }
                if (!(engine instanceof IMatchEngine)) continue;
                highest = (IMatchEngine)engine;
                break;
            }
        }
        if (highest == null) {
            for (Object engine : (List)this.get(ALL_EXTENSIONS)) {
                if (engine instanceof MatchEngineDescriptor) {
                    desc = (MatchEngineDescriptor)engine;
                    if (desc.getPriorityValue() <= highestPriority) continue;
                    highest = desc.getEngineInstance();
                    highestPriority = desc.getPriorityValue();
                    continue;
                }
                if (!(engine instanceof IMatchEngine)) continue;
                highest = (IMatchEngine)engine;
                break;
            }
        }
        return highest;
    }

    public void putValue(String key, Object value) {
        if (value instanceof IMatchEngine || value instanceof MatchEngineDescriptor) {
            ArrayList<Object> values = (ArrayList<Object>)this.get(key);
            if (values != null) {
                values.add(value);
            } else {
                values = new ArrayList<Object>();
                values.add(value);
                super.put(key, values);
            }
        } else {
            throw new IllegalArgumentException(EMFCompareMatchMessages.getString("MatchEngineRegistry.IllegalEngine", value.getClass().getName()));
        }
    }

    private MatchEngineDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        MatchEngineDescriptor desc = new MatchEngineDescriptor(configElement);
        return desc;
    }

    private void parseExtensionMetadata() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(MATCH_ENGINES_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String[] fileExtensions;
                MatchEngineDescriptor desc = this.parseEngine(configElements[j]);
                String[] stringArray = fileExtensions = desc.getFileExtension().split(",");
                int n = fileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    this.putValue(ext, desc);
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
    }
}

