/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.ListPackage;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.statesByCountry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListValidator
extends EObjectValidator {
    public static final ListValidator INSTANCE = new ListValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.schemaconstructs.list";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return ListPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatestatesByCountry((statesByCountry)value, diagnostics, context);
            }
            case 1: {
                return this.validateSixStatesList((List)value, diagnostics, context);
            }
            case 2: {
                return this.validateState((String)value, diagnostics, context);
            }
            case 3: {
                return this.validateStateList((List)value, diagnostics, context);
            }
            case 4: {
                return this.validateStringList((List)value, diagnostics, context);
            }
            case 5: {
                return this.validateZipCode((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatestatesByCountry(statesByCountry statesByCountry2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(statesByCountry2, diagnostics, context);
    }

    public boolean validateSixStatesList(List<?> sixStatesList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStateList_ItemType(sixStatesList, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateSixStatesList_MinLength(sixStatesList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSixStatesList_MaxLength(sixStatesList, diagnostics, context);
        }
        return result;
    }

    public boolean validateSixStatesList_MinLength(List<?> sixStatesList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = sixStatesList.size();
        boolean bl = result = length >= 6;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(ListPackage.Literals.SIX_STATES_LIST, sixStatesList, length, 6, diagnostics, context);
        }
        return result;
    }

    public boolean validateSixStatesList_MaxLength(List<?> sixStatesList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = sixStatesList.size();
        boolean bl = result = length <= 6;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListPackage.Literals.SIX_STATES_LIST, sixStatesList, length, 6, diagnostics, context);
        }
        return result;
    }

    public boolean validateState(String state, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateState_MaxLength(state, diagnostics, context);
        return result;
    }

    public boolean validateState_MaxLength(String state, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = state.length();
        boolean bl = result = length <= 12;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListPackage.Literals.STATE, state, length, 12, diagnostics, context);
        }
        return result;
    }

    public boolean validateStateList(List<?> stateList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStateList_ItemType(stateList, diagnostics, context);
        return result;
    }

    public boolean validateStateList_ItemType(List<?> stateList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = stateList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (ListPackage.Literals.STATE.isInstance(item)) {
                result &= this.validateState((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(ListPackage.Literals.STATE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateStringList(List<?> stringList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStringList_ItemType(stringList, diagnostics, context);
        return result;
    }

    public boolean validateStringList_ItemType(List<?> stringList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = stringList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.STRING.isInstance(item)) {
                result &= this.xmlTypeValidator.validateString((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.STRING, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateZipCode(String zipCode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateZipCode_MaxLength(zipCode, diagnostics, context);
        return result;
    }

    public boolean validateZipCode_MaxLength(String zipCode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = zipCode.length();
        boolean bl = result = length <= 6;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListPackage.Literals.ZIP_CODE, zipCode, length, 6, diagnostics, context);
        }
        return result;
    }
}

