/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies;

import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyStateEvent;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.internal.common.BuddyContainer;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.common.protocol.BuddyStateNotification;
import org.eclipse.net4j.internal.buddies.ClientBuddy;
import org.eclipse.net4j.internal.buddies.Self;
import org.eclipse.net4j.internal.buddies.bundle.OM;
import org.eclipse.net4j.internal.buddies.protocol.BuddiesClientProtocol;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSession
extends BuddyContainer
implements IBuddySession,
IListener {
    private BuddiesClientProtocol protocol;
    private Self self;

    public ClientSession(BuddiesClientProtocol protocol) {
        this.protocol = protocol;
    }

    public BuddiesClientProtocol getProtocol() {
        return this.protocol;
    }

    public Self getSelf() {
        return this.self;
    }

    public void setSelf(IAccount account, Set<String> facilityTypes) {
        this.self = new Self(this, account, facilityTypes);
        this.self.activate();
        this.self.addListener(this);
    }

    @Override
    public void close() {
        this.protocol.close();
        this.protocol = null;
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void notifyEvent(IEvent event) {
        if (event.getSource() == this.protocol) {
            if (event instanceof ILifecycleEvent && ((ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                this.deactivate();
            }
        } else if (event.getSource() == this.self && event instanceof IBuddyStateEvent) {
            try {
                new BuddyStateNotification((SignalProtocol)this.protocol, this.self.getUserID(), ((IBuddyStateEvent)event).getNewState()).sendAsync();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    public void buddyAdded(String userID) {
        ClientBuddy buddy = new ClientBuddy(this, userID);
        buddy.activate();
        this.addBuddy((IBuddy)buddy);
    }

    public void buddyRemoved(String userID) {
        IBuddy buddy = this.removeBuddy(userID);
        if (buddy != null) {
            IMembership[] iMembershipArray = this.self.getMemberships();
            int n = iMembershipArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMembership membership = iMembershipArray[n2];
                Collaboration collaboration = (Collaboration)membership.getCollaboration();
                collaboration.removeMembership(buddy);
                ++n2;
            }
            LifecycleUtil.deactivate((Object)buddy);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.protocol.addListener(this);
    }

    protected void doDeactivate() throws Exception {
        this.protocol.removeListener(this);
        LifecycleUtil.deactivate((Object)((Object)this.self));
        super.doDeactivate();
    }
}

