/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.sql.Timestamp;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DBType {
    BOOLEAN(16),
    BIT(-7),
    TINYINT(-6),
    SMALLINT(5),
    INTEGER(4),
    BIGINT(-5),
    FLOAT(6),
    REAL(7),
    DOUBLE(8),
    NUMERIC(2),
    DECIMAL(3),
    CHAR(1),
    VARCHAR(12),
    LONGVARCHAR(-1, "LONG VARCHAR"),
    DATE(91){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    TIME(92){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    TIMESTAMP(93){

        public void appendValue(StringBuilder builder, Object value) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("Not a java.util.Date: " + value);
            }
            Date date = (Date)value;
            builder.append("'");
            builder.append(new Timestamp(date.getTime()));
            builder.append("'");
        }
    }
    ,
    BINARY(-2){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    VARBINARY(-3){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    LONGVARBINARY(-4, "LONG VARBINARY"){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    BLOB(2004){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CLOB(2005){

        public void appendValue(StringBuilder builder, Object value) {
            throw new UnsupportedOperationException();
        }
    };

    private int code;
    private String keyword;

    private DBType(int code, String keyword) {
        this.code = code;
        this.keyword = keyword;
    }

    private DBType(int code) {
        this(code, (String)null);
    }

    public int getCode() {
        return this.code;
    }

    public String getKeyword() {
        return this.keyword == null ? super.toString() : this.keyword;
    }

    public String toString() {
        return this.getKeyword();
    }

    public void appendValue(StringBuilder builder, Object value) {
        if (value == null) {
            builder.append("NULL");
        } else if (value instanceof String || value instanceof Character) {
            builder.append("'");
            builder.append(value);
            builder.append("'");
        } else {
            builder.append(value);
        }
    }

    /* synthetic */ DBType(String string, int n, int n2, DBType dBType) {
        this(n2);
    }

    /* synthetic */ DBType(String string, int n, int n2, String string2, DBType dBType) {
        this(n2, string2);
    }
}

