/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class SelectorUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, SelectorUtil.class);

    private SelectorUtil() {
    }

    public static String formatInterestOps(int newOps) {
        StringBuilder builder = new StringBuilder();
        if ((newOps & 0x10) != 0) {
            SelectorUtil.addInterestOp(builder, "ACCEPT");
        }
        if ((newOps & 8) != 0) {
            SelectorUtil.addInterestOp(builder, "CONNECT");
        }
        if ((newOps & 1) != 0) {
            SelectorUtil.addInterestOp(builder, "READ");
        }
        if ((newOps & 4) != 0) {
            SelectorUtil.addInterestOp(builder, "WRITE");
        }
        return builder.toString();
    }

    public static void setInterest(SelectionKey selectionKey, int operation, boolean interested) {
        if (selectionKey == null || !selectionKey.isValid()) {
            return;
        }
        try {
            int oldOps = selectionKey.interestOps();
            int newOps = interested ? oldOps | operation : oldOps & ~operation;
            if (oldOps != newOps) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Setting interest " + SelectorUtil.formatInterestOps(newOps) + (oldOps == 0 ? "" : " (was " + SelectorUtil.formatInterestOps(oldOps).toLowerCase() + ")"));
                }
                selectionKey.interestOps(newOps);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {}
    }

    public static void setAcceptInterest(SelectionKey selectionKey, boolean interested) {
        SelectorUtil.setInterest(selectionKey, 16, interested);
    }

    public static void setConnectInterest(SelectionKey selectionKey, boolean interested) {
        SelectorUtil.setInterest(selectionKey, 8, interested);
    }

    public static void setReadInterest(SelectionKey selectionKey, boolean interested) {
        SelectorUtil.setInterest(selectionKey, 1, interested);
    }

    public static void setWriteInterest(SelectionKey selectionKey, boolean interested) {
        SelectorUtil.setInterest(selectionKey, 4, interested);
    }

    private static void addInterestOp(StringBuilder builder, String op) {
        if (builder.length() != 0) {
            builder.append("|");
        }
        builder.append(op);
    }
}

