/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public abstract class SashComposite
extends Composite {
    private boolean vertical;
    private FormLayout form;
    private Sash sash;
    private Control control1;
    private Control control2;
    private FormData sashData;
    private FormData control1Data;
    private FormData control2Data;
    private int limit;
    private int percent;

    public SashComposite(Composite parent, int style, int limit, int percent) {
        this(parent, style, limit, percent, true);
    }

    public SashComposite(Composite parent, int style, int limit, int percent, boolean vertical) {
        super(parent, style);
        this.vertical = vertical;
        this.limit = limit;
        this.percent = percent;
        this.form = new FormLayout();
        this.setLayout((Layout)this.form);
        this.control1Data = new FormData();
        this.control1 = this.createControl1(this);
        this.control1.setLayoutData((Object)this.control1Data);
        this.sashData = new FormData();
        this.sash = this.createSash(this);
        this.sash.setLayoutData((Object)this.sashData);
        this.control2Data = new FormData();
        this.control2 = this.createControl2(this);
        this.control2.setLayoutData((Object)this.control2Data);
        this.init();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        if (this.vertical != vertical) {
            this.vertical = vertical;
            Sash newSash = this.createSash(this);
            newSash.moveBelow(this.control1);
            newSash.setLayoutData(this.sash.getLayoutData());
            this.sash.setLayoutData(null);
            this.sash.dispose();
            this.sash = newSash;
            this.init();
            this.layout();
        }
    }

    public Sash getSash() {
        return this.sash;
    }

    public Control getControl1() {
        return this.control1;
    }

    public Control getControl2() {
        return this.control2;
    }

    protected void init() {
        this.control1Data.left = new FormAttachment(0, 0);
        this.control1Data.right = new FormAttachment((Control)this.sash, 0);
        this.control1Data.top = new FormAttachment(0, 0);
        this.control1Data.bottom = new FormAttachment(100, 0);
        this.sashData.left = new FormAttachment(this.percent, 0);
        this.sashData.right = null;
        this.sashData.top = new FormAttachment(0, 0);
        this.sashData.bottom = new FormAttachment(100, 0);
        this.control2Data.left = new FormAttachment((Control)this.sash, 0);
        this.control2Data.right = new FormAttachment(100, 0);
        this.control2Data.top = new FormAttachment(0, 0);
        this.control2Data.bottom = new FormAttachment(100, 0);
        if (!this.vertical) {
            this.swap();
        }
    }

    protected void swap() {
        this.swap(this.control1Data);
        this.swap(this.sashData);
        this.swap(this.control2Data);
    }

    protected void swap(FormData formData) {
        FormAttachment tmp = formData.left;
        formData.left = formData.top;
        formData.top = tmp;
        tmp = formData.right;
        formData.right = formData.bottom;
        formData.bottom = tmp;
    }

    protected Sash createSash(Composite parent) {
        Sash sash = new Sash(parent, this.vertical ? 512 : 256);
        sash.addListener(13, (Listener)new SashListener());
        return sash;
    }

    protected abstract Control createControl1(Composite var1);

    protected abstract Control createControl2(Composite var1);

    private final class SashListener
    implements Listener {
        public void handleEvent(Event e) {
            Rectangle sashRect = SashComposite.this.sash.getBounds();
            Rectangle shellRect = SashComposite.this.getClientArea();
            if (SashComposite.this.vertical) {
                int right = shellRect.width - sashRect.width - SashComposite.this.limit;
                e.x = Math.max(Math.min(e.x, right), SashComposite.this.limit);
                if (e.x != sashRect.x) {
                    ((SashComposite)SashComposite.this).sashData.left = new FormAttachment(0, e.x);
                    SashComposite.this.layout();
                }
            } else {
                int bottom = shellRect.height - sashRect.height - SashComposite.this.limit;
                e.y = Math.max(Math.min(e.y, bottom), SashComposite.this.limit);
                if (e.y != sashRect.y) {
                    ((SashComposite)SashComposite.this).sashData.top = new FormAttachment(0, e.y);
                    SashComposite.this.layout();
                }
            }
        }
    }
}

