/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dbgen.impl;

import java.util.Collection;
import org.eclipse.emf.cdo.dbgen.Column;
import org.eclipse.emf.cdo.dbgen.ColumnNotFoundException;
import org.eclipse.emf.cdo.dbgen.ColumnType;
import org.eclipse.emf.cdo.dbgen.DBGenFactory;
import org.eclipse.emf.cdo.dbgen.DBGenPackage;
import org.eclipse.emf.cdo.dbgen.Database;
import org.eclipse.emf.cdo.dbgen.Index;
import org.eclipse.emf.cdo.dbgen.IndexNotFoundException;
import org.eclipse.emf.cdo.dbgen.IndexType;
import org.eclipse.emf.cdo.dbgen.Table;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.net4j.util.StringHelper;

public class TableImpl
extends EObjectImpl
implements Table {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList columns = null;
    protected EList indices = null;

    protected TableImpl() {
    }

    protected EClass eStaticClass() {
        return DBGenPackage.Literals.TABLE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    public Database getDatabase() {
        if (this.eContainerFeatureID != 1) {
            return null;
        }
        return (Database)this.eContainer();
    }

    public NotificationChain basicSetDatabase(Database newDatabase, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newDatabase, 1, msgs);
        return msgs;
    }

    public void setDatabase(Database newDatabase) {
        if (newDatabase != this.eInternalContainer() || this.eContainerFeatureID != 1 && newDatabase != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newDatabase)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newDatabase != null) {
                msgs = ((InternalEObject)newDatabase).eInverseAdd((InternalEObject)this, 1, Database.class, msgs);
            }
            if ((msgs = this.basicSetDatabase(newDatabase, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newDatabase, (Object)newDatabase));
        }
    }

    public EList getColumns() {
        if (this.columns == null) {
            this.columns = new EObjectContainmentWithInverseEList(Column.class, (InternalEObject)this, 2, 1);
        }
        return this.columns;
    }

    public EList getIndices() {
        if (this.indices == null) {
            this.indices = new EObjectContainmentWithInverseEList(Index.class, (InternalEObject)this, 3, 1);
        }
        return this.indices;
    }

    public Index getPrimaryIndex() {
        for (Index index : this.getIndices()) {
            if (index.getType().getValue() != 2) continue;
            return index;
        }
        return null;
    }

    public Column getColumn(String name) {
        for (Column column : this.getColumns()) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        throw new ColumnNotFoundException("column " + name + " not found in table " + this.getName());
    }

    public Column addColumn(String name, ColumnType type, int length, String constraint) {
        Column column = DBGenFactory.eINSTANCE.createColumn();
        column.setName(name);
        column.setType(type);
        column.setLength(length);
        column.setConstraint(constraint);
        column.setTable(this);
        return column;
    }

    public Column addColumn(String name, ColumnType type, int length) {
        return this.addColumn(name, type, length, null);
    }

    public Column addColumn(String name, ColumnType type, String constraint) {
        return this.addColumn(name, type, 0, constraint);
    }

    public Column addColumn(String name, ColumnType type) {
        return this.addColumn(name, type, 0);
    }

    public Index getIndex(String name) {
        for (Index index : this.getIndices()) {
            if (!index.getName().equals(name)) continue;
            return index;
        }
        throw new IndexNotFoundException("index " + name + " not found in table " + this.getName());
    }

    public Index addIndex(String name, IndexType type) {
        Index index = DBGenFactory.eINSTANCE.createIndex();
        index.setName(name);
        index.setType(type);
        index.setTable(this);
        return index;
    }

    public Index addSimpleIndex(String columnName, IndexType indexType) {
        Index index = this.addIndex(columnName, indexType);
        index.addColumn(columnName);
        return index;
    }

    public Index addCompoundIndex(String columnNames, IndexType indexType) {
        throw new UnsupportedOperationException();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetDatabase((Database)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getColumns()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getIndices()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetDatabase(null, msgs);
            }
            case 2: {
                return ((InternalEList)this.getColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getIndices()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, Database.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDatabase();
            }
            case 2: {
                return this.getColumns();
            }
            case 3: {
                return this.getIndices();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setDatabase((Database)newValue);
                return;
            }
            case 2: {
                this.getColumns().clear();
                this.getColumns().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getIndices().clear();
                this.getIndices().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setDatabase(null);
                return;
            }
            case 2: {
                this.getColumns().clear();
                return;
            }
            case 3: {
                this.getIndices().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.getDatabase() != null;
            }
            case 2: {
                return this.columns != null && !this.columns.isEmpty();
            }
            case 3: {
                return this.indices != null && !this.indices.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Index addCompoundIndex(String[] columnNames, IndexType indexType) {
        if (columnNames == null) {
            throw new IllegalArgumentException("columnNames is null");
        }
        if (columnNames.length == 0) {
            throw new IllegalArgumentException("columnNames is empty");
        }
        String indexName = StringHelper.implode((Object[])columnNames, (String)"_");
        Index index = this.addIndex(indexName, indexType);
        int i = 0;
        while (i < columnNames.length) {
            index.addColumn(columnNames[i]);
            ++i;
        }
        return index;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

