/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.client.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.protocol.ClientCDOResProtocolImpl;
import org.eclipse.emf.cdo.examples.client.ResourceCache;
import org.eclipse.emf.cdo.examples.client.internal.ResourceCacheImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.spring.Container;
import org.eclipse.net4j.spring.ContainerCreationException;
import org.eclipse.net4j.spring.impl.ContainerImpl;
import org.eclipse.net4j.util.eclipse.AbstractPlugin;
import org.osgi.framework.Bundle;

public class ExampleClientPlugin
extends AbstractPlugin {
    public static final String CONTEXT_PATH = "META-INF/";
    private static ExampleClientPlugin plugin;
    private static Connector cachedConnector;
    private static Container container;
    private static Container clientContainer;
    private static ResourceCache resourceCache;

    public ExampleClientPlugin() {
        if (plugin == null) {
            plugin = this;
        }
    }

    public static ExampleClientPlugin getDefault() {
        return plugin;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        if (resourceCache != null) {
            resourceCache.dispose();
            resourceCache = null;
        }
        if (cachedConnector != null) {
            cachedConnector.stop();
            cachedConnector = null;
        }
        if (clientContainer != null) {
            clientContainer.stop();
            clientContainer = null;
        }
        if (container != null) {
            container.stop();
            container = null;
        }
        plugin = null;
    }

    public static Container getContainer() {
        if (container == null) {
            String baseResourcePath;
            try {
                baseResourcePath = ExampleClientPlugin.getBundleLocation((Bundle)ExampleClientPlugin.getDefault().getBundle());
            }
            catch (IOException ex) {
                throw new ContainerCreationException("Error while computing location of bundle " + ExampleClientPlugin.getDefault().getBundle(), (Throwable)ex);
            }
            String location = "META-INF/common.xml";
            String name = "common";
            Container parent = null;
            ClassLoader classLoader = ExampleClientPlugin.getDefault().getClassLoader();
            container = new ContainerImpl(baseResourcePath, location, name, parent, classLoader);
        }
        return container;
    }

    public static Container getClientContainer() {
        if (clientContainer == null) {
            String baseResourcePath;
            try {
                baseResourcePath = ExampleClientPlugin.getBundleLocation((Bundle)ExampleClientPlugin.getDefault().getBundle());
            }
            catch (IOException ex) {
                throw new ContainerCreationException("Error while computing location of bundle " + ExampleClientPlugin.getDefault().getBundle(), (Throwable)ex);
            }
            String location = "META-INF/client.xml";
            String name = "client";
            Container parent = ExampleClientPlugin.getContainer();
            ClassLoader classLoader = ExampleClientPlugin.getDefault().getClassLoader();
            clientContainer = new ContainerImpl(baseResourcePath, location, name, parent, classLoader);
        }
        return clientContainer;
    }

    public static Connector getConnector() {
        if (cachedConnector == null) {
            cachedConnector = (Connector)ExampleClientPlugin.getClientContainer().getBean("connector");
        }
        return cachedConnector;
    }

    public static ResourceManager createResourceManager(ResourceSet resourceSet) {
        ResourceManager resourceManager = (ResourceManager)ExampleClientPlugin.getClientContainer().getBean("resourceManager");
        resourceManager.setResourceSet(resourceSet);
        try {
            resourceManager.start();
        }
        catch (Exception ex) {
            ExampleClientPlugin.getDefault().error("Problem while starting ResourceManager " + resourceManager, ex);
        }
        return resourceManager;
    }

    public static PackageManager getPackageManager() {
        PackageManager packageManager = (PackageManager)ExampleClientPlugin.getClientContainer().getBean("packageManager");
        return packageManager;
    }

    public static ResourceCache getResourceCache() {
        if (resourceCache == null) {
            ClientCDOResProtocolImpl protocol = (ClientCDOResProtocolImpl)ExampleClientPlugin.getClientContainer().getBean("clientCDOResProtocol");
            resourceCache = new ResourceCacheImpl(protocol, ExampleClientPlugin.getConnector());
        }
        return resourceCache;
    }

    public static ResourceCache createResourceCache(final ResourceManager resourceManager) {
        return new ResourceCache(){

            @Override
            public List<ResourceInfo> getAllResources() {
                ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
                EList resources = resourceManager.getResourceSet().getResources();
                for (Resource resource : resources) {
                    if (!(resource instanceof CDOResource)) continue;
                    CDOResource cdoResource = (CDOResource)resource;
                    cdoResource.getPath();
                    result.add(cdoResource.getInfo());
                }
                return result;
            }

            @Override
            public void dispose() {
            }

            @Override
            public Channel getChannel() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void addListener(ResourceCache.Listener listener) {
            }

            @Override
            public void removeListener(ResourceCache.Listener listener) {
            }
        };
    }
}

