/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

/**
 * Interface for contributors of {@link IItemJavaElementSource}s.
 * Clients wishing to provide their implementation of {@link IItemJavaElementSource}
 * should contribute it through extension point
 * <code>org.eclipse.emf.mint.itemJavaElementSourceContributors</code>.
 * Note that this will only work for model URIs whose registered
 * adapter factory supports extensibility using this mechanism.
 * 
 * <p>Clients may implement this interface.</p>
 */
public interface IItemJavaElementSourceContributor {

	/**
	 * Returns an instance of {@link IItemJavaElementSource} for
	 * the given model element.
	 *  
	 * @param object model element
	 * @return Java element source for the given model object
	 */
	IItemJavaElementSource getItemJavaElementSource(Object object);
}
