/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.controller;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IController;
import org.eclipse.net4j.examples.mvc.IRecordController;
import org.eclipse.net4j.examples.mvc.binding.EnablementViewBinding;
import org.eclipse.net4j.examples.mvc.binding.RecordModelBinding;
import org.eclipse.net4j.examples.mvc.binding.SelectionViewBinding;
import org.eclipse.net4j.examples.mvc.binding.TextViewBinding;
import org.eclipse.net4j.examples.mvc.controller.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordController<RECORD_TARGET, VIEW_TARGET>
extends Controller<Object>
implements IRecordController<RECORD_TARGET, VIEW_TARGET> {
    public static final String RECORD_TARGET_NAME = "record";
    private EnablementViewBinding<VIEW_TARGET> loadEnablementBinding;
    private SelectionViewBinding<VIEW_TARGET> loadSelectionBinding;
    private EnablementViewBinding<VIEW_TARGET> saveEnablementBinding;
    private SelectionViewBinding<VIEW_TARGET> saveSelectionBinding;
    private Map<String, AbstractRecordBridge<RECORD_TARGET>> bridges = new HashMap<String, AbstractRecordBridge<RECORD_TARGET>>();
    private boolean recordTransient;

    public RecordController(IAdapter.Manager<Object> adapterManager, String name) {
        super(adapterManager, name);
    }

    public RecordController(IAdapter.Manager<Object> adapterManager, String name, RECORD_TARGET recordTarget) {
        super(adapterManager, name);
        this.setRecordTarget(recordTarget);
    }

    @Override
    public RECORD_TARGET getRecordTarget() {
        return (RECORD_TARGET)this.getTarget(RECORD_TARGET_NAME);
    }

    @Override
    public RECORD_TARGET setRecordTarget(RECORD_TARGET target) {
        return this.putTarget(RECORD_TARGET_NAME, target);
    }

    public EnablementViewBinding<VIEW_TARGET> getLoadEnablementBinding() {
        return this.loadEnablementBinding;
    }

    public EnablementViewBinding<VIEW_TARGET> getSaveEnablementBinding() {
        return this.saveEnablementBinding;
    }

    public SelectionViewBinding<VIEW_TARGET> getLoadSelectionBinding() {
        return this.loadSelectionBinding;
    }

    public void setLoadBinding(String loadTargetName) {
        this.loadEnablementBinding = new EnablementViewBinding<Object>(this, loadTargetName);
        this.loadSelectionBinding = new SelectionViewBinding<VIEW_TARGET>(this, loadTargetName){

            @Override
            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                RecordController.this.loadView();
                return true;
            }
        };
    }

    public SelectionViewBinding<VIEW_TARGET> getSaveSelectionBinding() {
        return this.saveSelectionBinding;
    }

    public void setSaveBinding(String saveTargetName) {
        this.saveEnablementBinding = new EnablementViewBinding<Object>(this, saveTargetName);
        this.saveSelectionBinding = new SelectionViewBinding<VIEW_TARGET>(this, saveTargetName){

            @Override
            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                RecordController.this.saveView();
                return true;
            }
        };
    }

    @Override
    public void addTextBridge(String textTargetName, String fieldName) {
        TextRecordBridge bridge = new TextRecordBridge(this, RECORD_TARGET_NAME, fieldName, false, textTargetName);
        this.bridges.put(textTargetName, bridge);
    }

    @Override
    public void addSelectionBridge(String selectionTargetName, String fieldName) {
        SelectionRecordBridge bridge = new SelectionRecordBridge(this, RECORD_TARGET_NAME, fieldName, false, selectionTargetName);
        this.bridges.put(selectionTargetName, bridge);
    }

    @Override
    public boolean isDirty() {
        for (AbstractRecordBridge<RECORD_TARGET> bridge : this.bridges.values()) {
            if (!bridge.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDirty(boolean on) {
        for (AbstractRecordBridge<RECORD_TARGET> bridge : this.bridges.values()) {
            bridge.setDirty(on);
        }
    }

    @Override
    public boolean isTransient() {
        return this.recordTransient;
    }

    @Override
    public void setTransient(boolean on) {
        this.recordTransient = on;
    }

    @Override
    public void enableView(boolean on) {
        for (AbstractRecordBridge<RECORD_TARGET> bridge : this.bridges.values()) {
            bridge.enable(on);
        }
    }

    @Override
    public void clearView() {
        for (AbstractRecordBridge<RECORD_TARGET> bridge : this.bridges.values()) {
            bridge.clear();
        }
        this.updateEnablements();
    }

    @Override
    public void loadView() {
        if (this.getRecordTarget() == null) {
            this.clearView();
            return;
        }
        for (AbstractRecordBridge<RECORD_TARGET> bridge : this.bridges.values()) {
            bridge.load();
        }
        this.setTransient(false);
        this.updateEnablements();
    }

    @Override
    public void saveView() {
        for (AbstractRecordBridge<RECORD_TARGET> bridge : this.bridges.values()) {
            bridge.save();
        }
        this.setTransient(false);
        this.updateEnablements();
    }

    @Override
    public void afterTargetsSet() {
        super.afterTargetsSet();
        this.loadView();
    }

    protected void updateEnablements() {
        boolean dirty = this.isDirty();
        if (this.loadEnablementBinding != null) {
            this.loadEnablementBinding.setEnabled(dirty && !this.isTransient());
        }
        if (this.saveEnablementBinding != null) {
            this.saveEnablementBinding.setEnabled(dirty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractRecordBridge<TARGET> {
        private String fieldName;
        private boolean autoSave;
        private boolean dirty = true;
        private RecordModelBinding<TARGET> recordBinding;
        private EnablementViewBinding<Object> enablementBinding;

        public AbstractRecordBridge(IController controller, String recordTargetName, String fieldName, boolean autoSync, String viewTargetName) {
            this.fieldName = fieldName;
            this.autoSave = autoSync;
            this.recordBinding = new RecordModelBinding(controller, recordTargetName){

                public void onSet(String fieldName, Object newValue, Object oldValue) {
                    if (fieldName.equals(AbstractRecordBridge.this.getFieldName())) {
                        this.doSync();
                    }
                }

                public Object setTarget(Object target) {
                    Object oldTarget = super.setTarget(target);
                    if (target != oldTarget) {
                        this.doSync();
                    }
                    return oldTarget;
                }

                private void doSync() {
                    if (AbstractRecordBridge.this.isAutoSave()) {
                        AbstractRecordBridge.this.save();
                        AbstractRecordBridge.this.setDirty(false);
                    } else {
                        AbstractRecordBridge.this.setDirty(true);
                    }
                }
            };
            this.enablementBinding = new EnablementViewBinding(controller, viewTargetName);
        }

        public RecordModelBinding<TARGET> getRecordModelBinding() {
            return this.recordBinding;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class getFieldType() {
            return this.getRecordModelBinding().getFieldType(this.fieldName);
        }

        public boolean isAutoSave() {
            return this.autoSave;
        }

        public void setAutoSave(boolean recordAutoSync) {
            this.autoSave = recordAutoSync;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean recordDirty) {
            if (this.dirty == recordDirty) {
                return;
            }
            this.dirty = recordDirty;
            RecordController.this.updateEnablements();
        }

        protected abstract void clear();

        protected abstract void load();

        protected abstract void save();

        protected String fieldToString(Object value) {
            return value == null ? "" : value.toString();
        }

        protected Object fieldFromString(String text) {
            Class fieldType = this.getFieldType();
            if (fieldType == Character.TYPE) {
                return Character.valueOf(text.length() == 0 ? (char)'\u0000' : text.charAt(0));
            }
            if (fieldType == Boolean.TYPE) {
                return !"false".equals(text);
            }
            if (fieldType == Byte.TYPE) {
                return Byte.parseByte(text);
            }
            if (fieldType == Short.TYPE) {
                return Short.parseShort(text);
            }
            if (fieldType == Integer.TYPE) {
                return Integer.parseInt(text);
            }
            if (fieldType == Long.TYPE) {
                return Long.parseLong(text);
            }
            if (fieldType == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(text));
            }
            if (fieldType == Double.TYPE) {
                return Double.parseDouble(text);
            }
            if (fieldType == String.class) {
                return text;
            }
            return null;
        }

        protected int fieldToInteger(Object value) {
            Class fieldType = this.getFieldType();
            if (fieldType == Character.TYPE) {
                return ((Character)value).charValue();
            }
            if (fieldType == Boolean.TYPE) {
                return (Boolean)value != false ? 1 : 0;
            }
            if (fieldType == Byte.TYPE) {
                return ((Byte)value).byteValue();
            }
            if (fieldType == Short.TYPE) {
                return ((Short)value).shortValue();
            }
            if (fieldType == Integer.TYPE) {
                return (Integer)value;
            }
            if (fieldType == Long.TYPE) {
                return (int)((Long)value).longValue();
            }
            if (fieldType == Float.TYPE) {
                return (int)((Float)value).floatValue();
            }
            if (fieldType == Double.TYPE) {
                return (int)((Double)value).doubleValue();
            }
            if (fieldType == String.class) {
                return new Integer((String)value);
            }
            return 0;
        }

        protected Object fieldFromInteger(int number) {
            Class fieldType = this.getFieldType();
            if (fieldType == Character.TYPE) {
                return new Character((char)number);
            }
            if (fieldType == Boolean.TYPE) {
                return new Boolean(number != 0);
            }
            if (fieldType == Byte.TYPE) {
                return new Byte((byte)number);
            }
            if (fieldType == Short.TYPE) {
                return new Short((short)number);
            }
            if (fieldType == Integer.TYPE) {
                return new Integer(number);
            }
            if (fieldType == Long.TYPE) {
                return new Long(number);
            }
            if (fieldType == Float.TYPE) {
                return new Float(number);
            }
            if (fieldType == Double.TYPE) {
                return new Double(number);
            }
            if (fieldType == String.class) {
                return Integer.toString(number);
            }
            return null;
        }

        protected void enable(boolean on) {
            this.getEnablementBinding().setEnabled(on);
        }

        public EnablementViewBinding<Object> getEnablementBinding() {
            return this.enablementBinding;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TextRecordBridge<RECORD_TARGET2, TEXT_TARGET>
    extends AbstractRecordBridge<RECORD_TARGET2> {
        private TextViewBinding<TEXT_TARGET> textBinding;

        public TextRecordBridge(IController controller, String recordTargetName, String fieldName, boolean autoSync, String textTargetName) {
            super(controller, recordTargetName, fieldName, autoSync, textTargetName);
            this.textBinding = new TextViewBinding(controller, textTargetName){

                public void onModify() {
                    TextRecordBridge.this.setDirty(true);
                    if (TextRecordBridge.this.isAutoSave()) {
                        TextRecordBridge.this.save();
                        TextRecordBridge.this.setDirty(false);
                    }
                }
            };
        }

        public TextViewBinding<TEXT_TARGET> getTextViewBinding() {
            return this.textBinding;
        }

        @Override
        protected void clear() {
            this.getTextViewBinding().setText("");
            this.setDirty(false);
        }

        @Override
        protected void load() {
            String value = this.fieldToString(this.getRecordModelBinding().getValue(this.getFieldName()));
            this.getTextViewBinding().setText(value);
            this.setDirty(false);
        }

        @Override
        protected void save() {
            if (this.isDirty()) {
                Object value = this.fieldFromString(this.getTextViewBinding().getText());
                this.getRecordModelBinding().setValue(this.getFieldName(), value);
                this.setDirty(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectionRecordBridge<RECORD_TARGET2, SELECTION_TARGET>
    extends AbstractRecordBridge<RECORD_TARGET2> {
        private SelectionViewBinding<SELECTION_TARGET> selectionViewBinding;

        public SelectionRecordBridge(IController controller, String recordTargetName, String fieldName, boolean autoSync, String selectionTargetName) {
            super(controller, recordTargetName, fieldName, autoSync, selectionTargetName);
            this.selectionViewBinding = new SelectionViewBinding(controller, selectionTargetName){

                public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                    SelectionRecordBridge.this.setDirty(true);
                    if (SelectionRecordBridge.this.isAutoSave()) {
                        SelectionRecordBridge.this.save();
                    }
                    return true;
                }
            };
        }

        public SelectionViewBinding<SELECTION_TARGET> getSelectionViewBinding() {
            return this.selectionViewBinding;
        }

        @Override
        protected void clear() {
            this.getSelectionViewBinding().setSelection(-1);
            this.setDirty(false);
        }

        @Override
        protected void load() {
            int index;
            if (this.isIntegral()) {
                index = this.fieldToInteger(this.getRecordModelBinding().getValue(this.getFieldName()));
            } else {
                String value = this.fieldToString(this.getRecordModelBinding().getValue(this.getFieldName()));
                index = this.getSelectionViewBinding().indexOf(value);
            }
            this.getSelectionViewBinding().setSelection(index);
            this.setDirty(false);
        }

        @Override
        protected void save() {
            if (this.isDirty()) {
                Object value = this.fieldFromInteger(this.getSelectionViewBinding().getSelectionIndex());
                this.getRecordModelBinding().setValue(this.getFieldName(), value);
                this.setDirty(false);
            }
        }

        private boolean isIntegral() {
            Class fieldType = this.getFieldType();
            return fieldType == Character.TYPE || fieldType == Boolean.TYPE || fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE;
        }
    }
}

