/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.client.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.examples.client.ClientActivator;
import org.eclipse.net4j.examples.client.ui.BusyTemplate;
import org.eclipse.net4j.examples.mvc.DensityMvcPlugin;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IController;
import org.eclipse.net4j.examples.mvc.IRecordController;
import org.eclipse.net4j.examples.mvc.ISequenceController;
import org.eclipse.net4j.examples.mvc.binding.SelectionViewBinding;
import org.eclipse.net4j.examples.mvc.controller.MetaDataRecordController;
import org.eclipse.net4j.examples.mvc.controller.SelectionSequenceController;
import org.eclipse.net4j.examples.mvc.swt.AbstractControlledDialog;
import org.eclipse.net4j.examples.prov.Category;
import org.eclipse.net4j.examples.prov.Feature;
import org.eclipse.net4j.examples.prov.ProvFactory;
import org.eclipse.net4j.examples.prov.Site;
import org.eclipse.net4j.examples.prov.client.protocol.UploadArchiveRequest;
import org.eclipse.net4j.examples.prov.provider.ProvItemProviderAdapterFactory;
import org.eclipse.net4j.util.IOHelper;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProvisioningDialog
extends AbstractControlledDialog {
    private static ComposedAdapterFactory emfAdapterFactory;
    private Channel channel;
    private Site site;
    private CheckboxTableViewer featuresTable;
    private IRecordController<Category, Control> recordController;
    private ISequenceController<EList, Category, Control> sequenceController;

    public ProvisioningDialog(Shell parentShell, Channel channel, Site site) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.channel = channel;
        this.site = site;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(container, 0);
        main.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        main.setLayout((Layout)gridLayout);
        SashForm sashForm = new SashForm(main, 0);
        GridData gridData_2 = new GridData(1808);
        sashForm.setLayoutData((Object)gridData_2);
        Group left = new Group((Composite)sashForm, 0);
        left.setLayout((Layout)new GridLayout());
        left.setText("Categories");
        Composite categoriesContainer = new Composite((Composite)left, 0);
        categoriesContainer.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.marginWidth = 0;
        gridLayout_7.marginHeight = 0;
        categoriesContainer.setLayout((Layout)gridLayout_7);
        List categoriesList = new List(categoriesContainer, 2048);
        categoriesList.setData("target", (Object)"categoriesList");
        categoriesList.setLayoutData((Object)new GridData(1808));
        Composite composite_1 = new Composite((Composite)left, 0);
        composite_1.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.marginWidth = 0;
        gridLayout_4.marginHeight = 0;
        gridLayout_4.numColumns = 2;
        composite_1.setLayout((Layout)gridLayout_4);
        Label label = new Label(composite_1, 0);
        label.setText("Label:");
        Text labelText = new Text(composite_1, 2048);
        labelText.setData("target", (Object)"labelText");
        labelText.setData("fieldName", (Object)"label");
        labelText.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label(composite_1, 0);
        label_1.setLayoutData((Object)new GridData(2));
        label_1.setText("Description:");
        Text descriptionText = new Text(composite_1, 2114);
        descriptionText.setData("target", (Object)"descriptionText");
        descriptionText.setData("fieldName", (Object)"description");
        GridData gridData = new GridData(768);
        gridData.heightHint = 40;
        descriptionText.setLayoutData((Object)gridData);
        Composite composite_4 = new Composite((Composite)left, 0);
        composite_4.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.marginWidth = 0;
        gridLayout_6.marginHeight = 0;
        gridLayout_6.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_6);
        Button newButton = new Button(composite_4, 0);
        newButton.setData("sequenceAction", (Object)"new");
        newButton.setData("target", (Object)"newButton");
        newButton.setText("New...");
        Button deleteButton = new Button(composite_4, 0);
        deleteButton.setData("sequenceAction", (Object)"delete");
        deleteButton.setData("target", (Object)"deleteButton");
        deleteButton.setText("Delete");
        Button resetButton = new Button(composite_4, 0);
        resetButton.setData("recordAction", (Object)"load");
        resetButton.setData("target", (Object)"resetButton");
        resetButton.setText("Reset");
        Composite composite_2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.horizontalSpacing = 10;
        gridLayout_5.numColumns = 2;
        gridLayout_5.marginWidth = 0;
        gridLayout_5.marginHeight = 0;
        composite_2.setLayout((Layout)gridLayout_5);
        Composite composite_3 = new Composite(composite_2, 0);
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 0;
        composite_3.setLayoutData((Object)gridData_3);
        Group right = new Group(composite_2, 0);
        right.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 2;
        right.setLayout((Layout)gridLayout_3);
        right.setText("Features");
        Composite featuresContainer = new Composite((Composite)right, 0);
        featuresContainer.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        featuresContainer.setLayout((Layout)gridLayout_1);
        Composite composite = new Composite((Composite)right, 0);
        composite.setLayoutData((Object)new GridData(2));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.marginWidth = 0;
        gridLayout_2.marginHeight = 0;
        composite.setLayout((Layout)gridLayout_2);
        Button uploadArchiveButton = new Button(composite, 0);
        uploadArchiveButton.setData("target", (Object)"uploadArchiveButton");
        uploadArchiveButton.setLayoutData((Object)new GridData(768));
        uploadArchiveButton.setText("Upload Archive...");
        Button uploadFolderButton = new Button(composite, 0);
        uploadFolderButton.setData("target", (Object)"uploadFolderButton");
        uploadFolderButton.setLayoutData((Object)new GridData(768));
        uploadFolderButton.setText("Upload Folder...");
        Button removeButton = new Button(composite, 0);
        removeButton.setData("target", (Object)"removeButton");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText("Remove");
        sashForm.setWeights(new int[]{2, 3});
        this.createFeaturesTable(featuresContainer);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(700, 375);
    }

    protected void initControllers() {
        this.recordController = new MetaDataRecordController<Category, Control>((IAdapter.Manager)DensityMvcPlugin.getAdapterManager(), "record"){

            public void enableView(boolean on) {
                super.enableView(on);
                ProvisioningDialog.this.featuresTable.setAllGrayed(!on);
                ProvisioningDialog.this.featuresTable.getTable().setEnabled(on);
            }

            public void clearView() {
                super.clearView();
                ProvisioningDialog.this.featuresTable.setAllChecked(false);
            }

            public void loadView() {
                super.loadView();
                Category category = (Category)this.getRecordTarget();
                if (category != null) {
                    EList features = ProvisioningDialog.this.getSite().getFeatures();
                    for (Feature feature : features) {
                        ProvisioningDialog.this.featuresTable.setChecked((Object)feature, category.getFeature(feature.getId(), feature.getVersion()) != null);
                    }
                }
            }

            public void saveView() {
                super.saveView();
                Category category = (Category)this.getRecordTarget();
                EList features = category.getFeatures();
                features.clear();
                Object[] checked = ProvisioningDialog.this.featuresTable.getCheckedElements();
                int i = 0;
                while (i < checked.length) {
                    Feature feature = (Feature)checked[i];
                    features.add((Object)EcoreUtil.copy((EObject)feature));
                    ++i;
                }
            }
        };
        this.addController((IController)this.recordController);
        this.sequenceController = new SelectionSequenceController<EList, Category, Control>((IAdapter.Manager)DensityMvcPlugin.getAdapterManager(), "sequence", "sequence", "categoriesList", this.recordController){

            protected String itemToString(Object item) {
                return ((Category)item).getName();
            }

            protected Object createNewItem() {
                InputDialog dlg = new InputDialog(ProvisioningDialog.this.getShell(), "New Category", "Please enter the name of the new category:", "", (IInputValidator)new NewCategoryValidator(ProvisioningDialog.this.getSite()));
                if (dlg.open() != 0) {
                    return null;
                }
                Category item = ProvFactory.eINSTANCE.createCategory();
                item.setName(dlg.getValue());
                return item;
            }
        };
        this.sequenceController.setNewBinding("newButton");
        this.sequenceController.setDeleteBinding("deleteButton");
        this.addController((IController)this.sequenceController);
        this.sequenceController.setSequenceTarget((Object)this.getSite().getCategories());
        new SelectionViewBinding((IController)this.sequenceController, "uploadArchiveButton"){

            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                ProvisioningDialog.this.onUploadArchive();
                return true;
            }
        };
        new SelectionViewBinding((IController)this.sequenceController, "uploadFolderButton"){

            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                ProvisioningDialog.this.onUploadFolder();
                return true;
            }
        };
    }

    public Site getSite() {
        return this.site;
    }

    protected void createFeaturesTable(Composite parent) {
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 200;
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                EList features = (EList)inputElement;
                return features.toArray(new Object[features.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.featuresTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.featuresTable.getTable().setLayoutData((Object)data);
        this.featuresTable.setContentProvider((IContentProvider)contentProvider);
        this.featuresTable.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)ProvisioningDialog.getEmfAdapterFactory()));
        this.featuresTable.setSorter(new ViewerSorter());
        this.featuresTable.setInput((Object)this.getSite().getFeatures());
        this.featuresTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProvisioningDialog.this.sequenceController.setRecordDirty(true);
            }
        });
    }

    protected void onUploadArchive() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Select an archive to upload");
        dialog.setFilterExtensions(new String[]{"*.zip; *.jar", "*.zip", "*.jar", "*.*"});
        dialog.setFilterNames(new String[]{"All Archives", "ZIP Archives", "JAR Archives", "All Files"});
        String fileName = dialog.open();
        if (fileName != null) {
            this.uploadArchive(fileName);
        }
    }

    protected void onUploadFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText("Select a folder to upload");
        String folderName = dialog.open();
        if (folderName != null) {
            File temp = ClientActivator.getTempManager().createTempFolder("upload");
            final File source = new File(folderName);
            final File target = new File(temp, String.valueOf(source.getName()) + ".zip");
            new BusyTemplate(this.getShell()){

                protected Object run() throws Exception {
                    IOHelper.zip((File)source, (File)target, (boolean)true);
                    return null;
                }
            }.execute();
            this.uploadArchive(target.getAbsolutePath());
            ClientActivator.getTempManager().release(temp);
        }
    }

    protected void uploadArchive(final String fileName) {
        Feature[] features = (Feature[])new BusyTemplate(this.getShell()){

            protected Object run() throws Exception {
                UploadArchiveRequest request = new UploadArchiveRequest(fileName);
                return ProvisioningDialog.this.channel.transmit((Request)request);
            }
        }.execute();
        if (features == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Upload Archive", (String)"An error has occured and no features have been installed.");
        } else {
            int i = 0;
            while (i < features.length) {
                Feature feature = features[i];
                this.getSite().addFeature(feature.getId(), feature.getVersion());
                ++i;
            }
            this.featuresTable.refresh();
        }
    }

    public static ComposedAdapterFactory getEmfAdapterFactory() {
        if (emfAdapterFactory == null) {
            ArrayList<Object> factories = new ArrayList<Object>();
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new ProvItemProviderAdapterFactory());
            emfAdapterFactory = new ComposedAdapterFactory(factories);
        }
        return emfAdapterFactory;
    }

    public static class NewCategoryValidator
    implements IInputValidator {
        private Site site;

        public NewCategoryValidator(Site site) {
            this.site = site;
        }

        public String isValid(String newText) {
            if (newText == null || newText.length() == 0) {
                return "The name of the new category must not be empty!";
            }
            if (this.site.getCategory(newText) != null) {
                return "A category with the name '" + newText + "' does already exist!";
            }
            return null;
        }
    }
}

