/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.UIEvent;

public class FocusManager {
    protected EventTarget lastFocusEventTarget;
    protected Document document;
    protected EventListener mouseclickListener;
    protected EventListener domFocusInListener;
    protected EventListener domFocusOutListener;
    protected EventListener mouseoverListener;
    protected EventListener mouseoutListener;

    public FocusManager(Document document) {
        this.document = document;
        EventTarget eventTarget = (EventTarget)((Object)document);
        this.mouseclickListener = new MouseClickTacker();
        eventTarget.addEventListener("click", this.mouseclickListener, true);
        this.mouseoverListener = new MouseOverTacker();
        eventTarget.addEventListener("mouseover", this.mouseoverListener, true);
        this.mouseoutListener = new MouseOutTacker();
        eventTarget.addEventListener("mouseout", this.mouseoutListener, true);
        this.domFocusInListener = new DOMFocusInTracker();
        eventTarget.addEventListener("DOMFocusIn", this.domFocusInListener, true);
        this.domFocusOutListener = new DOMFocusOutTracker();
        eventTarget.addEventListener("DOMFocusOut", this.domFocusOutListener, true);
    }

    public EventTarget getCurrentEventTarget() {
        return this.lastFocusEventTarget;
    }

    public void dispose() {
        if (this.document == null) {
            return;
        }
        EventTarget eventTarget = (EventTarget)((Object)this.document);
        eventTarget.removeEventListener("click", this.mouseclickListener, true);
        eventTarget.removeEventListener("mouseover", this.mouseoverListener, true);
        eventTarget.removeEventListener("mouseout", this.mouseoutListener, true);
        eventTarget.removeEventListener("DOMFocusIn", this.domFocusInListener, true);
        eventTarget.removeEventListener("DOMFocusOut", this.domFocusOutListener, true);
        this.lastFocusEventTarget = null;
        this.document = null;
    }

    protected void fireDOMFocusInEvent(EventTarget eventTarget) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        UIEvent uIEvent = (UIEvent)documentEvent.createEvent("UIEvents");
        uIEvent.initUIEvent("DOMFocusIn", true, false, null, 0);
        eventTarget.dispatchEvent(uIEvent);
    }

    protected void fireDOMFocusOutEvent(EventTarget eventTarget) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        UIEvent uIEvent = (UIEvent)documentEvent.createEvent("UIEvents");
        uIEvent.initUIEvent("DOMFocusOut", true, false, null, 0);
        eventTarget.dispatchEvent(uIEvent);
    }

    protected void fireDOMActivateEvent(EventTarget eventTarget, int n) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Element)((Object)eventTarget)).getOwnerDocument());
        UIEvent uIEvent = (UIEvent)documentEvent.createEvent("UIEvents");
        uIEvent.initUIEvent("DOMActivate", true, true, null, n);
        eventTarget.dispatchEvent(uIEvent);
    }

    protected class DOMFocusInTracker
    implements EventListener {
        protected DOMFocusInTracker() {
        }

        public void handleEvent(Event event) {
            if (FocusManager.this.lastFocusEventTarget != null && FocusManager.this.lastFocusEventTarget != event.getTarget()) {
                FocusManager.this.fireDOMFocusOutEvent(FocusManager.this.lastFocusEventTarget);
            }
            FocusManager.this.lastFocusEventTarget = event.getTarget();
        }
    }

    protected class DOMFocusOutTracker
    implements EventListener {
        protected DOMFocusOutTracker() {
        }

        public void handleEvent(Event event) {
            FocusManager.this.lastFocusEventTarget = null;
        }
    }

    protected class MouseClickTacker
    implements EventListener {
        protected MouseClickTacker() {
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            FocusManager.this.fireDOMActivateEvent(event.getTarget(), mouseEvent.getDetail());
        }
    }

    protected class MouseOutTacker
    implements EventListener {
        protected MouseOutTacker() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            FocusManager.this.fireDOMFocusOutEvent(eventTarget);
        }
    }

    protected class MouseOverTacker
    implements EventListener {
        protected MouseOverTacker() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            FocusManager.this.fireDOMFocusInEvent(eventTarget);
        }
    }
}

