/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.layout;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeProvider;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractLayoutNodeProvider
extends AbstractProvider
implements ILayoutNodeProvider {
    protected View getContainer(IOperation operation) {
        View container = null;
        if (operation instanceof ILayoutNodeOperation) {
            ListIterator nodes = ((ILayoutNodeOperation)operation).getLayoutNodes().listIterator();
            if (nodes.hasNext()) {
                Node node = ((ILayoutNode)nodes.next()).getNode();
                container = ViewUtil.getContainerView((View)node);
            }
        } else {
            return null;
        }
        return container;
    }

    protected Map getNodeToSizeMap(ILayoutNodeOperation operation) {
        List layoutNodes = operation.getLayoutNodes();
        HashMap<Node, Dimension> viewsToSizesMap = new HashMap<Node, Dimension>(layoutNodes.size());
        ListIterator nodes = layoutNodes.listIterator();
        while (nodes.hasNext()) {
            ILayoutNode layoutNode = (ILayoutNode)nodes.next();
            Node node = layoutNode.getNode();
            viewsToSizesMap.put(node, new Dimension(layoutNode.getWidth(), layoutNode.getHeight()));
        }
        return viewsToSizesMap;
    }
}

