/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.tests.validate.AnnotationUtil;
import org.eclipse.gmf.tests.validate.DynamicModelHelper;
import org.eclipse.gmf.validate.GMFValidator;
import org.eclipse.gmf.validate.ValidationOptions;

public class AnnotatedOclValidatorTest
extends TestCase {
    EClass eClass;

    public AnnotatedOclValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EPackage model = DynamicModelHelper.createMetaModel();
        this.eClass = DynamicModelHelper.createMetaClass(model);
    }

    public void testCorrectConstraint() throws Exception {
        AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, "true");
        Diagnostic status = GMFValidator.validate((EObject)this.eClass);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testInvalidConstraintBody() throws Exception {
        EAnnotation constraint = AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, ";-)");
        Diagnostic status = GMFValidator.validate((EObject)this.eClass);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        AnnotatedOclValidatorTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_VALUE_EXPRESSION);
        AnnotatedOclValidatorTest.assertSame((Object)this.eClass, (Object)AnnotationUtil.getChildDiagnosticSource(status));
        String defaultMessage = AnnotationUtil.getChildDiagnostic(status).getMessage();
        AnnotatedOclValidatorTest.assertNotNull((Object)defaultMessage);
        AnnotatedOclValidatorTest.assertTrue((defaultMessage.indexOf(AnnotationUtil.OCL.getConstraintBodyDetail(constraint).getValue()) >= 0 ? 1 : 0) != 0);
    }

    public void testMissingConstraintBody() throws Exception {
        EAnnotation constraint = AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, null);
        Diagnostic status = GMFValidator.validate((EObject)this.eClass);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 2 ? 1 : 0) != 0);
        AnnotatedOclValidatorTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.EMPTY_CONSTRAINT_BODY);
        AnnotatedOclValidatorTest.assertSame(AnnotationUtil.OCL.getConstraintBodyDetail(constraint), (Object)AnnotationUtil.getChildDiagnosticSource(status));
    }

    public void testInvalidConstraintExpressionType() throws Exception {
        AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, "'aString'");
        Diagnostic status = GMFValidator.validate((EObject)this.eClass);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        AnnotatedOclValidatorTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_EXPRESSION_TYPE);
        AnnotatedOclValidatorTest.assertSame((Object)this.eClass, (Object)AnnotationUtil.getChildDiagnosticSource(status));
    }

    public void testValidConstrainedElement() {
        AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, "true");
        EObject target = EcoreUtil.create((EClass)this.eClass);
        ValidationOptions opts = new ValidationOptions();
        opts.setReportSuccess(true);
        Diagnostic status = GMFValidator.validate((EObject)target, (ValidationOptions)opts);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 0 ? 1 : 0) != 0);
        AnnotatedOclValidatorTest.assertSame((Object)target, (Object)AnnotationUtil.getChildDiagnosticSource(status));
        AnnotatedOclValidatorTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)226);
        String defaultMessage = AnnotationUtil.getChildDiagnostic(status).getMessage();
        AnnotatedOclValidatorTest.assertNotNull((Object)defaultMessage);
        AnnotatedOclValidatorTest.assertTrue((defaultMessage.trim().length() > 0 ? 1 : 0) != 0);
    }

    public void testInvalidConstrainedElement() {
        AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, "false");
        EObject target = EcoreUtil.create((EClass)this.eClass);
        Diagnostic status = GMFValidator.validate((EObject)target);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        AnnotatedOclValidatorTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)225);
        AnnotatedOclValidatorTest.assertSame((Object)target, (Object)AnnotationUtil.getChildDiagnosticSource(status));
    }

    public void testInvalidConstrainetContext() {
        EPackage invalidCtx = this.eClass.getEPackage();
        EAnnotation constraint = AnnotationUtil.OCL.createConstraint((EModelElement)invalidCtx, "true");
        Diagnostic status = GMFValidator.validate((EObject)invalidCtx);
        AnnotatedOclValidatorTest.assertTrue((status.getSeverity() == 2 ? 1 : 0) != 0);
        AnnotatedOclValidatorTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_CONSTRAINT_CONTEXT);
        AnnotatedOclValidatorTest.assertSame((Object)constraint, (Object)AnnotationUtil.getChildDiagnosticSource(status));
    }

    public void testImplicitEObjectOperationsEnabled() {
        AnnotationUtil.OCL.createConstraint((EModelElement)this.eClass, "eContainer().oclIsUndefined() and eClass().name = '" + this.eClass.getName() + '\'');
        Diagnostic status = GMFValidator.validate((EObject)this.eClass);
        String msg = AnnotationUtil.getChildDiagnostic(status) != null ? AnnotationUtil.getChildDiagnostic(status).getMessage() : status.getMessage();
        AnnotatedOclValidatorTest.assertTrue((String)msg, (status.getSeverity() == 0 ? 1 : 0) != 0);
        EObject target = EcoreUtil.create((EClass)this.eClass);
        status = GMFValidator.validate((EObject)target);
        msg = AnnotationUtil.getChildDiagnostic(status) != null ? AnnotationUtil.getChildDiagnostic(status).getMessage() : status.getMessage();
        AnnotatedOclValidatorTest.assertTrue((String)msg, (status.getSeverity() == 0 ? 1 : 0) != 0);
    }
}

