/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation;

import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironmentFactory;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoGenericEngine
implements IAcceleoEngine {
    private final List<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>(3);
    private OCL ocl;

    @Override
    public void addListener(IAcceleoTextGenerationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Map<String, Writer> evaluate(Template template, List<? extends Object> arguments, File generationRoot, boolean preview, Monitor monitor) {
        if (template == null || arguments == null || !preview && generationRoot == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEngine.NullArguments"));
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != arguments.size()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalArguments"));
        }
        AcceleoEnvironmentFactory factory = new AcceleoEnvironmentFactory(generationRoot, (Module)template.eContainer(), new ArrayList<IAcceleoTextGenerationListener>(this.listeners), preview, monitor);
        this.ocl = OCL.newInstance((EnvironmentFactory)factory);
        ((AcceleoEnvironment)this.ocl.getEnvironment()).restoreBrokenEnvironmentPackages(template.eResource());
        try {
            this.doEvaluate(template, arguments);
        }
        catch (AcceleoEvaluationCancelledException acceleoEvaluationCancelledException) {}
        Map<String, Writer> result = Collections.emptyMap();
        if (preview) {
            result = factory.getEvaluationPreview();
        }
        factory.dispose();
        return result;
    }

    @Override
    public void removeListener(IAcceleoTextGenerationListener listener) {
        this.listeners.remove(listener);
    }

    private void doEvaluate(Template template, List<? extends Object> arguments) {
        Object value;
        Variable param;
        int i;
        boolean guardValue = true;
        if (template.getGuard() != null) {
            OCL.Query guard = this.ocl.createQuery((OCLExpression)template.getGuard());
            i = 0;
            while (i < template.getParameter().size()) {
                param = (Variable)template.getParameter().get(i);
                value = arguments.get(i);
                if (!((EClassifier)param.getType()).isInstance(value)) {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.ArgumentMismatch", template.getName()));
                }
                guard.getEvaluationEnvironment().add(param.getName(), value);
                if (i == 0) {
                    guard.getEvaluationEnvironment().add("self", value);
                }
                ++i;
            }
            guardValue = (Boolean)guard.evaluate();
        }
        if (guardValue) {
            OCL.Query query = this.ocl.createQuery((OCLExpression)template);
            i = 0;
            while (i < template.getParameter().size()) {
                param = (Variable)template.getParameter().get(i);
                value = arguments.get(i);
                if (!((EClassifier)param.getType()).isInstance(value)) {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.ArgumentMismatch", template.getName()));
                }
                query.getEvaluationEnvironment().add(param.getName(), value);
                if (i == 0) {
                    query.getEvaluationEnvironment().add("self", value);
                }
                ++i;
            }
            query.evaluate();
        }
    }
}

