/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib.workspace;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction2;
import org.eclipse.jet.taglib.workspace.IWorkspaceActionExtension;
import org.eclipse.jet.transform.TransformContextExtender;
import org.eclipse.jet.transform.TransformContextListener;

public final class WorkspaceContextExtender {
    private static String PRIVATE_CONTEXT_DATA_KEY;
    private static final String RESOURCE_VAR_PREFIX = "org.eclipse.jet.resource.";
    public static final String VAR_RESOURCE_PARENT_PROJECT_RELATIVE_PATH = "org.eclipse.jet.resource.parent.projectRelativePath";
    public static final String VAR_RESOURCE_PARENT_FULL_PATH = "org.eclipse.jet.resource.parent.fullPath";
    public static final String VAR_RESOURCE_PARENT_RAW_LOCATION = "org.eclipse.jet.resource.parent.rawLocation";
    public static final String VAR_RESOURCE_PARENT_LOCATION = "org.eclipse.jet.resource.parent.location";
    public static final String VAR_RESOURCE_PARENT_NAME = "org.eclipse.jet.resource.parent.name";
    public static final String VAR_RESOURCE_FILE_NAME = "org.eclipse.jet.resource.fileName";
    public static final String VAR_RESOURCE_FILE_EXTENSION = "org.eclipse.jet.resource.fileExtension";
    public static final String VAR_RESOURCE_PROJECT_RELATIVE_PATH = "org.eclipse.jet.resource.projectRelativePath";
    public static final String VAR_RESOURCE_FULL_PATH = "org.eclipse.jet.resource.fullPath";
    public static final String VAR_RESOURCE_PROJECT_NAME = "org.eclipse.jet.resource.project.name";
    public static final String VAR_RAW_LOCATION = "org.eclipse.jet.resource.rawLocation";
    public static final String VAR_RESOURCE_LOCATION = "org.eclipse.jet.resource.location";
    public static final String VAR_RESOURCE_TYPE = "org.eclipse.jet.resource.type";
    public static final String VAR_RESOURCE_NAME = "org.eclipse.jet.resource.name";
    private final ContextData contextData;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.taglib.workspace.WorkspaceContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PRIVATE_CONTEXT_DATA_KEY = clazz.getName();
    }

    public WorkspaceContextExtender(JET2Context context) {
        this(context, WorkspaceContextExtender.getInstance((JET2Context)context).contextData);
    }

    private WorkspaceContextExtender(JET2Context context, ContextData contextData) {
        this.contextData = contextData;
        TransformContextExtender.getInstance(context).addListener(contextData);
    }

    public void addAction(IWorkspaceAction action) {
        this.contextData.workspaceActions.add(action);
    }

    public void addFinalAction(IWorkspaceAction action) {
        this.contextData.finalWorkspaceActions.add(action);
    }

    public void pushContainer(IContainer container) {
        this.contextData.containerStack.push(container);
    }

    public void popContainer() throws JET2TagException {
        if (this.contextData.containerStack.isEmpty()) {
            throw new JET2TagException(JET2Messages.WorkspaceContextExtender_NoParent);
        }
        this.contextData.containerStack.pop();
    }

    public boolean existsContainer() {
        return !this.contextData.containerStack.isEmpty();
    }

    public IContainer getContainer() throws JET2TagException {
        if (this.contextData.containerStack.isEmpty()) {
            throw new JET2TagException(JET2Messages.WorkspaceContextExtender_NoParent);
        }
        return (IContainer)this.contextData.containerStack.peek();
    }

    public static WorkspaceContextExtender getInstance(JET2Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        WorkspaceContextExtender ex = (WorkspaceContextExtender)context.getPrivateData(PRIVATE_CONTEXT_DATA_KEY);
        if (ex == null) {
            ex = new WorkspaceContextExtender(context, new ContextData());
            context.addPrivateData(PRIVATE_CONTEXT_DATA_KEY, (Object)ex);
        }
        return ex;
    }

    public static void loadResourceAsSource(JET2Context context, IResource resource, String resourceLoaderId, String resourceType) throws CoreJETException, IOException {
        URL url = new URL("platform:/resource" + resource.getFullPath());
        Object source = TransformContextExtender.loadModel(url, resourceLoaderId, resourceType);
        context.setSource(source);
        String name = resource.getName();
        try {
            context.setVariable(VAR_RESOURCE_NAME, (Object)name);
            context.setVariable(VAR_RESOURCE_TYPE, (Object)WorkspaceContextExtender.getResourceTypeString(resource.getType()));
            context.setVariable(VAR_RESOURCE_LOCATION, (Object)resource.getLocation().toString());
            context.setVariable(VAR_RAW_LOCATION, (Object)(resource.getRawLocation() != null ? resource.getRawLocation().toString() : resource.getLocation().toString()));
            context.setVariable(VAR_RESOURCE_PROJECT_NAME, (Object)resource.getProject().getName());
            context.setVariable(VAR_RESOURCE_FULL_PATH, (Object)resource.getFullPath().toString());
            context.setVariable(VAR_RESOURCE_PROJECT_RELATIVE_PATH, (Object)resource.getProjectRelativePath().toString());
            String fileExtension = resource.getFileExtension();
            context.setVariable(VAR_RESOURCE_FILE_EXTENSION, (Object)fileExtension);
            context.setVariable(VAR_RESOURCE_FILE_NAME, (Object)(fileExtension == null ? name : name.substring(0, name.length() - fileExtension.length() - 1)));
            switch (resource.getType()) {
                case 1: 
                case 2: {
                    context.setVariable(VAR_RESOURCE_PARENT_NAME, (Object)resource.getParent().getName());
                    context.setVariable(VAR_RESOURCE_PARENT_LOCATION, (Object)resource.getParent().getLocation().toString());
                    context.setVariable(VAR_RESOURCE_PARENT_RAW_LOCATION, (Object)(resource.getParent().getRawLocation() == null ? resource.getParent().getLocation().toString() : resource.getParent().getRawLocation().toString()));
                    context.setVariable(VAR_RESOURCE_PARENT_FULL_PATH, (Object)resource.getParent().getFullPath().toString());
                    context.setVariable(VAR_RESOURCE_PARENT_PROJECT_RELATIVE_PATH, (Object)resource.getParent().getProjectRelativePath().toString());
                    break;
                }
            }
        }
        catch (JET2TagException e) {
            InternalJET2Platform.logError("Invalid variable name", (Exception)((Object)e));
        }
    }

    private static String getResourceTypeString(int type) {
        switch (type) {
            case 1: {
                return "file";
            }
            case 2: {
                return "folder";
            }
            case 4: {
                return "project";
            }
            case 8: {
                return "root";
            }
        }
        return "unknown";
    }

    private static final class ContextData
    implements TransformContextListener {
        public final List workspaceActions = new ArrayList();
        public final Stack containerStack = new Stack();
        public final List finalWorkspaceActions = new ArrayList();

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit(JET2Context context, IProgressMonitor monitor) throws JET2TagException {
            int actionsToExecuteCount = this.workspaceActions.size() + this.finalWorkspaceActions.size();
            ArrayList actionsToExecute = new ArrayList(actionsToExecuteCount);
            actionsToExecute.addAll(this.workspaceActions);
            actionsToExecute.addAll(this.finalWorkspaceActions);
            TransformContextExtender tce = TransformContextExtender.getInstance(context);
            monitor.beginTask(JET2Messages.WorkspaceContextExtender_Commiting, 1 + actionsToExecuteCount);
            try {
                try {
                    monitor.subTask(JET2Messages.WorkspaceContextExtender_ConfirmingTeamAccess);
                    ArrayList filesToValidateEdit = new ArrayList(actionsToExecute.size());
                    Iterator i = actionsToExecute.iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            IStatus validateOk = ResourcesPlugin.getWorkspace().validateEdit(filesToValidateEdit.toArray(new IFile[filesToValidateEdit.size()]), tce.getShellContext());
                            if (validateOk.isOK()) break;
                            throw new JET2TagException(validateOk.getMessage());
                        }
                        IWorkspaceAction action = (IWorkspaceAction)i.next();
                        if (this.isActionRequired(context, action)) {
                            this.doActionRequiresValidateEdit(context, action, filesToValidateEdit);
                            continue;
                        }
                        i.remove();
                    }
                    monitor.worked(1);
                    monitor.subTask(JET2Messages.WorkspaceContextExtender_WritingFiles);
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, actionsToExecute, context){
                        final /* synthetic */ ContextData this$1;
                        private final /* synthetic */ List val$actionsToExecute;
                        private final /* synthetic */ JET2Context val$context;
                        {
                            this.this$1 = contextData;
                            this.val$actionsToExecute = list;
                            this.val$context = jET2Context;
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run(IProgressMonitor submon) throws CoreException {
                            submon.beginTask(null, this.val$actionsToExecute.size());
                            try {
                                Iterator<E> i = this.val$actionsToExecute.iterator();
                                while (i.hasNext()) {
                                    IWorkspaceAction action = (IWorkspaceAction)i.next();
                                    this.this$1.doActionPerformAction(this.val$context, action, submon);
                                    submon.worked(1);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                submon.done();
                                throw throwable;
                            }
                            {
                                Object var4_6 = null;
                            }
                            submon.done();
                        }
                    }, (IProgressMonitor)new SubProgressMonitor(monitor, actionsToExecute.size()));
                }
                catch (CoreException e) {
                    throw new JET2TagException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var9_12 = null;
            }
            monitor.done();
        }

        protected boolean isActionRequired(JET2Context context, IWorkspaceAction action) {
            IResource resource = this.getActionResource(action);
            if (resource != null && !(resource instanceof IFile)) {
                return !resource.exists();
            }
            if (!(action instanceof IWorkspaceActionExtension)) {
                return true;
            }
            IWorkspaceActionExtension ext = (IWorkspaceActionExtension)((Object)action);
            IFile file = (IFile)resource;
            InputStream existingContents = null;
            if (file != null && file.exists()) {
                try {
                    existingContents = file.getContents();
                }
                catch (CoreException coreException) {}
            }
            return ActionsUtil.finalizeAndTestForChange(file, ext.getContentWriter(), existingContents);
        }

        private IResource getActionResource(IWorkspaceAction action) {
            IResource resource;
            try {
                resource = action.getResource();
            }
            catch (JET2TagException jET2TagException) {
                resource = null;
            }
            return resource;
        }

        protected void doActionRequiresValidateEdit(JET2Context context, IWorkspaceAction action, List filesToValidateEdit) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, context, action, filesToValidateEdit){
                final /* synthetic */ ContextData this$1;
                private final /* synthetic */ JET2Context val$context;
                private final /* synthetic */ IWorkspaceAction val$action;
                private final /* synthetic */ List val$filesToValidateEdit;
                {
                    this.this$1 = contextData;
                    this.val$context = jET2Context;
                    this.val$action = iWorkspaceAction;
                    this.val$filesToValidateEdit = list;
                }

                public void handleException(Throwable exception) {
                    this.val$context.logError(this.val$action.getTemplatePath(), this.val$action.getTagInfo(), null, exception);
                }

                public void run() throws Exception {
                    try {
                        if (this.val$action.requiresValidateEdit()) {
                            this.val$filesToValidateEdit.add(this.val$action.getResource());
                        }
                    }
                    catch (JET2TagException e) {
                        this.handleException(e);
                    }
                }
            });
        }

        protected void doActionCommitted(JET2Context context, IWorkspaceAction action) throws JET2TagException {
            IResource resource = this.getActionResource(action);
            if (action instanceof IWorkspaceActionExtension) {
                ActionsUtil.contentCommitted((JET2Writer)((IWorkspaceActionExtension)((Object)action)).getContentWriter(), resource);
            }
            if (resource != null) {
                String msgPattern;
                switch (resource.getType()) {
                    case 1: {
                        msgPattern = JET2Messages.WsFileFromWriterAction_WritingFile;
                        break;
                    }
                    case 2: {
                        msgPattern = JET2Messages.WsFolderAction_CreatingFolder;
                        break;
                    }
                    case 4: {
                        msgPattern = JET2Messages.WsProjectAction_CreatingProject;
                        break;
                    }
                    default: {
                        msgPattern = null;
                    }
                }
                if (msgPattern != null) {
                    String fileMessage = MessageFormat.format(msgPattern, resource.getFullPath().makeRelative().toString());
                    RuntimeLoggerContextExtender.log(context, fileMessage, action.getTagInfo(), action.getTemplatePath(), 3);
                }
            }
        }

        protected void doActionPerformAction(JET2Context context, IWorkspaceAction action, IProgressMonitor submon) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, context, action, submon){
                final /* synthetic */ ContextData this$1;
                private final /* synthetic */ JET2Context val$context;
                private final /* synthetic */ IWorkspaceAction val$action;
                private final /* synthetic */ IProgressMonitor val$submon;
                {
                    this.this$1 = contextData;
                    this.val$context = jET2Context;
                    this.val$action = iWorkspaceAction;
                    this.val$submon = iProgressMonitor;
                }

                public void handleException(Throwable exception) {
                    this.val$context.logError(this.val$action.getTemplatePath(), this.val$action.getTagInfo(), null, exception);
                }

                public void run() throws Exception {
                    try {
                        boolean written;
                        if (this.val$action instanceof IWorkspaceAction2) {
                            written = ((IWorkspaceAction2)this.val$action).performActionIfRequired((IProgressMonitor)new SubProgressMonitor(this.val$submon, 1));
                        } else {
                            this.val$action.performAction((IProgressMonitor)new SubProgressMonitor(this.val$submon, 1));
                            written = true;
                        }
                        if (written) {
                            this.this$1.doActionCommitted(this.val$context, this.val$action);
                        }
                    }
                    catch (JET2TagException e) {
                        this.handleException(e);
                    }
                }
            });
        }
    }
}

