/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.reasoner.structural;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.eodm.owl.reasoner.structural.Role;

public class RBox {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    private HashMap propertyMap = new HashMap();
    private int nextPropertyID = 0;
    private int size;
    private boolean[][] subPropertyMatrix = null;
    private String[] properties = null;
    private int topPropertyID;
    private int bottomPropertyID;

    public RBox() {
        this(10);
    }

    public RBox(int initCapacity) {
        this.size = initCapacity;
        this.subPropertyMatrix = new boolean[this.size][this.size];
        this.properties = new String[this.size];
        this.topPropertyID = this.getNextID();
        this.bottomPropertyID = this.getNextID();
        this.subPropertyMatrix[this.topPropertyID][this.topPropertyID] = true;
        this.subPropertyMatrix[this.bottomPropertyID][this.topPropertyID] = true;
        this.subPropertyMatrix[this.bottomPropertyID][this.bottomPropertyID] = true;
    }

    public int getTopPropertyID() {
        return this.topPropertyID;
    }

    public int getBottomPropertyID() {
        return this.bottomPropertyID;
    }

    public synchronized int getCreatePropertyID(Role p) {
        String name = p.getName();
        Integer id = (Integer)this.propertyMap.get(name);
        if (id == null) {
            id = new Integer(this.getNextID());
            this.subPropertyMatrix[id.intValue()][id.intValue()] = true;
            this.subPropertyMatrix[id.intValue()][this.topPropertyID] = true;
            this.subPropertyMatrix[this.bottomPropertyID][id.intValue()] = true;
            this.propertyMap.put(name, id);
            this.properties[id.intValue()] = name;
            return id;
        }
        return id;
    }

    public synchronized int getPropertyID(Role p) {
        String name = p.getName();
        Integer id = (Integer)this.propertyMap.get(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public synchronized void addSubPropertyOfAxiom(int child, int parent) {
        if (child < 0 || parent < 0 || child >= this.nextPropertyID || parent >= this.nextPropertyID) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.subPropertyMatrix[child][parent]) {
            return;
        }
        int i = 0;
        while (i < this.nextPropertyID) {
            if (this.subPropertyMatrix[i][child]) {
                int j = 0;
                while (j < this.nextPropertyID) {
                    if (this.subPropertyMatrix[parent][j]) {
                        this.subPropertyMatrix[i][j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public synchronized void addSubPropertyOfAxiom(Role child, Role parent) {
        this.addSubPropertyOfAxiom(this.getCreatePropertyID(child), this.getCreatePropertyID(parent));
    }

    public synchronized boolean isSubPropertyOf(int p1, int p2) {
        if (p1 < 0 || p2 < 0 || p1 >= this.nextPropertyID || p2 >= this.nextPropertyID) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.subPropertyMatrix[p1][p2];
    }

    public synchronized boolean isSubPropertyOf(Role p1, Role p2) {
        return this.isSubPropertyOf(this.getCreatePropertyID(p1), this.getCreatePropertyID(p2));
    }

    public synchronized List getSubProperties(int p) {
        if (p < 0 || p >= this.nextPropertyID) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.nextPropertyID) {
            if (this.subPropertyMatrix[i][p] && i != this.topPropertyID && i != this.bottomPropertyID) {
                result.add(this.properties[i]);
            }
            ++i;
        }
        return result;
    }

    public synchronized List getSubProperties(Role p) {
        return this.getSubProperties(this.getCreatePropertyID(p));
    }

    public synchronized List getSuperProperties(int p) {
        if (p < 0 || p >= this.nextPropertyID) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.nextPropertyID) {
            if (this.subPropertyMatrix[p][i] && i != this.topPropertyID && i != this.bottomPropertyID) {
                result.add(this.properties[i]);
            }
            ++i;
        }
        return result;
    }

    public synchronized List getSuperProperties(Role p) {
        return this.getSuperProperties(this.getCreatePropertyID(p));
    }

    private synchronized int getNextID() {
        if (this.nextPropertyID == this.size) {
            int newSize = this.size * 3 / 2;
            boolean[][] newMatrix = new boolean[newSize][newSize];
            String[] newPropertiesList = new String[newSize];
            int i = 0;
            while (i < this.size) {
                System.arraycopy(this.subPropertyMatrix[i], 0, newMatrix[i], 0, this.size);
                ++i;
            }
            System.arraycopy(this.properties, 0, newPropertiesList, 0, this.size);
            this.size = newSize;
            this.subPropertyMatrix = newMatrix;
            this.properties = newPropertiesList;
        }
        return this.nextPropertyID++;
    }
}

