/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.vocabulary.RDF;
import org.eclipse.eodm.vocabulary.RDFS;

public class RDFUtility {
    public static Namespace rdf;
    public static Namespace rdfs;
    public static URIReference rdfsresource;
    public static URIReference rdfsclass;
    public static URIReference rdfalt;
    public static URIReference rdfbag;
    public static URIReference rdflist;
    public static URIReference rdfseq;
    public static URIReference rdfstatement;
    public static URIReference rdfproperty;
    public static URIReference rdfscontainer;
    public static URIReference rdfscontainermembershipproperty;
    public static URIReference rdfsdatatype;
    static Random random;
    static HashMap eReferenceList;
    static HashMap featureIDList;
    static HashMap eClassList;
    static ArrayList predicateList;

    static {
        try {
            rdf = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            rdfs = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/2000/01/rdf-schema#");
            rdfsresource = RDFFactory.eINSTANCE.createURIReference(rdfs, "Resource");
            rdfsclass = RDFFactory.eINSTANCE.createURIReference(rdfs, "Class");
            rdfalt = RDFFactory.eINSTANCE.createURIReference(rdf, "Alt");
            rdfbag = RDFFactory.eINSTANCE.createURIReference(rdf, "Bag");
            rdflist = RDFFactory.eINSTANCE.createURIReference(rdf, "List");
            rdfseq = RDFFactory.eINSTANCE.createURIReference(rdf, "Seq");
            rdfstatement = RDFFactory.eINSTANCE.createURIReference(rdf, "Statement");
            rdfproperty = RDFFactory.eINSTANCE.createURIReference(rdf, "Property");
            rdfscontainer = RDFFactory.eINSTANCE.createURIReference(rdfs, "Container");
            rdfscontainermembershipproperty = RDFFactory.eINSTANCE.createURIReference(rdfs, "ContainerMembershipProperty");
            rdfsdatatype = RDFFactory.eINSTANCE.createURIReference(rdfs, "Datatype");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        random = new Random();
        eReferenceList = null;
        featureIDList = null;
        eClassList = null;
        predicateList = null;
    }

    public static ArrayList getPredicates() {
        if (predicateList == null) {
            predicateList = new ArrayList();
            int i = 0;
            while (i < RDF.ALL_RDF_PREDICATES_URIS.length) {
                predicateList.add(RDF.ALL_RDF_PREDICATES_URIS[i]);
                ++i;
            }
            i = 0;
            while (i < RDFS.ALL_RDFS_PREDICATES_URIS.length) {
                predicateList.add(RDFS.ALL_RDFS_PREDICATES_URIS[i]);
                ++i;
            }
        }
        return predicateList;
    }

    public static HashMap getEClass() {
        if (eClassList == null) {
            eClassList = new HashMap();
            eClassList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property", RDFBasePackage.eINSTANCE.getRDFProperty());
            eClassList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement", RDFBasePackage.eINSTANCE.getRDFStatement());
            eClassList.put("http://www.w3.org/2000/01/rdf-schema#Resource", RDFBasePackage.eINSTANCE.getRDFSResource());
            eClassList.put("http://www.w3.org/2000/01/rdf-schema#Class", RDFSPackage.eINSTANCE.getRDFSClass());
            eClassList.put("http://www.w3.org/2000/01/rdf-schema#Container", RDFSPackage.eINSTANCE.getRDFSContainer());
            eClassList.put("http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty", RDFSPackage.eINSTANCE.getRDFSContainerMembershipProperty());
            eClassList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag", RDFSPackage.eINSTANCE.getRDFBag());
            eClassList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt", RDFSPackage.eINSTANCE.getRDFAlt());
            eClassList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq", RDFSPackage.eINSTANCE.getRDFSeq());
            eClassList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#List", RDFSPackage.eINSTANCE.getRDFList());
            eClassList.put("http://www.w3.org/2000/01/rdf-schema#Datatype", RDFSPackage.eINSTANCE.getRDFSDatatype());
        }
        return eClassList;
    }

    public static HashMap getEReferenceList() {
        if (eReferenceList == null) {
            eReferenceList = new HashMap();
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#subClassOf", RDFSPackage.eINSTANCE.getRDFSClass_RDFSsubClassOf());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#subPropertyOf", RDFBasePackage.eINSTANCE.getRDFProperty_RDFSsubPropertyOf());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#domain", RDFBasePackage.eINSTANCE.getRDFProperty_RDFSdomain());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#range", RDFBasePackage.eINSTANCE.getRDFProperty_RDFSrange());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#comment", RDFBasePackage.eINSTANCE.getRDFSResource_RDFScomment());
            eReferenceList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", RDFBasePackage.eINSTANCE.getRDFSResource_RDFtype());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#label", RDFBasePackage.eINSTANCE.getRDFSResource_RDFSlabel());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#member", RDFBasePackage.eINSTANCE.getRDFSResource_RDFSmember());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#isDefinedBy", RDFBasePackage.eINSTANCE.getRDFSResource_RDFSisDefinedBy());
            eReferenceList.put("http://www.w3.org/2000/01/rdf-schema#seeAlso", RDFBasePackage.eINSTANCE.getRDFSResource_RDFSseeAlso());
            eReferenceList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#first", RDFSPackage.eINSTANCE.getRDFList_RDFfirst());
            eReferenceList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", RDFSPackage.eINSTANCE.getRDFList_RDFrest());
            eReferenceList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", RDFBasePackage.eINSTANCE.getRDFStatement_RDFsubject());
            eReferenceList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", RDFBasePackage.eINSTANCE.getRDFStatement_RDFpredicate());
            eReferenceList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#object", RDFBasePackage.eINSTANCE.getRDFStatement_RDFobject());
        }
        return eReferenceList;
    }

    public static HashMap getFeatureIDList() {
        if (featureIDList == null) {
            featureIDList = new HashMap();
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#subClassOf", new Integer(9));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#subPropertyOf", new Integer(38));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#domain", new Integer(36));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#range", new Integer(37));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#comment", new Integer(5));
            featureIDList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", new Integer(2));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#label", new Integer(6));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#member", new Integer(3));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#isDefinedBy", new Integer(0));
            featureIDList.put("http://www.w3.org/2000/01/rdf-schema#seeAlso", new Integer(1));
            featureIDList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#first", new Integer(34));
            featureIDList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", new Integer(35));
            featureIDList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", new Integer(70));
            featureIDList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", new Integer(72));
            featureIDList.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#object", new Integer(71));
        }
        return featureIDList;
    }

    public static int getFeatureIDbyPredicateURI(String uri) {
        if (RDFUtility.getFeatureIDList().get(uri) != null) {
            return (Integer)RDFUtility.getFeatureIDList().get(uri);
        }
        return 0;
    }

    public static String nodeidGenerator() {
        return "nodeid" + String.valueOf(new Date().getTime() + (long)random.nextInt());
    }
}

