/**
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation, Zeligsoft Inc., and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 225493, 243976, 259818
*   Zeligsoft - Bug 243976
*
* </copyright>
*
* $Id: OCLBacktrackingParsersym.java,v 1.1 2009/01/13 20:31:30 cdamus Exp $
*/

package org.eclipse.ocl.parser.backtracking;

/**
 * The backtracking variant of the OCL parser symbol table.
 * 
 * @noimplement This interface is not intended to be implemented by clients.
 * @noextend This interface is not intended to be extended by clients.
 * 
 * @since 1.3
 */
@SuppressWarnings("nls")
public interface OCLBacktrackingParsersym {
    public final static int
      TK_NUMERIC_OPERATION = 61,
      TK_STRING_LITERAL = 62,
      TK_INTEGER_LITERAL = 63,
      TK_REAL_LITERAL = 64,
      TK_PLUS = 28,
      TK_MINUS = 29,
      TK_MULTIPLY = 8,
      TK_DIVIDE = 9,
      TK_GREATER = 10,
      TK_LESS = 11,
      TK_EQUAL = 5,
      TK_GREATER_EQUAL = 12,
      TK_LESS_EQUAL = 13,
      TK_NOT_EQUAL = 7,
      TK_LPAREN = 2,
      TK_RPAREN = 3,
      TK_LBRACE = 93,
      TK_RBRACE = 74,
      TK_LBRACKET = 94,
      TK_RBRACKET = 79,
      TK_ARROW = 85,
      TK_BAR = 70,
      TK_COMMA = 31,
      TK_COLON = 37,
      TK_COLONCOLON = 80,
      TK_SEMICOLON = 81,
      TK_DOT = 86,
      TK_DOTDOT = 87,
      TK_ATPRE = 75,
      TK_CARET = 88,
      TK_CARETCARET = 89,
      TK_QUESTIONMARK = 95,
      TK_self = 30,
      TK_inv = 76,
      TK_pre = 71,
      TK_post = 72,
      TK_context = 77,
      TK_package = 96,
      TK_endpackage = 82,
      TK_def = 78,
      TK_if = 69,
      TK_then = 90,
      TK_else = 91,
      TK_endif = 84,
      TK_and = 25,
      TK_or = 26,
      TK_xor = 27,
      TK_not = 53,
      TK_implies = 92,
      TK_let = 68,
      TK_in = 83,
      TK_true = 65,
      TK_false = 66,
      TK_body = 6,
      TK_derive = 14,
      TK_init = 15,
      TK_null = 38,
      TK_attr = 98,
      TK_oper = 99,
      TK_Set = 32,
      TK_Bag = 33,
      TK_Sequence = 34,
      TK_Collection = 35,
      TK_OrderedSet = 36,
      TK_iterate = 39,
      TK_forAll = 40,
      TK_exists = 41,
      TK_isUnique = 42,
      TK_any = 43,
      TK_one = 44,
      TK_collect = 45,
      TK_select = 46,
      TK_reject = 47,
      TK_collectNested = 48,
      TK_sortedBy = 49,
      TK_closure = 50,
      TK_oclIsKindOf = 54,
      TK_oclIsTypeOf = 55,
      TK_oclAsType = 56,
      TK_oclIsNew = 57,
      TK_oclIsUndefined = 58,
      TK_oclIsInvalid = 59,
      TK_oclIsInState = 60,
      TK_allInstances = 51,
      TK_String = 16,
      TK_Integer = 17,
      TK_UnlimitedNatural = 18,
      TK_Real = 19,
      TK_Boolean = 20,
      TK_Tuple = 52,
      TK_OclAny = 21,
      TK_OclVoid = 22,
      TK_Invalid = 23,
      TK_OclMessage = 24,
      TK_OclInvalid = 67,
      TK_EOF_TOKEN = 73,
      TK_IDENTIFIER = 4,
      TK_INTEGER_RANGE_START = 97,
      TK_ERROR_TOKEN = 1;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "ERROR_TOKEN",
                 "LPAREN",
                 "RPAREN",
                 "IDENTIFIER",
                 "EQUAL",
                 "body",
                 "NOT_EQUAL",
                 "MULTIPLY",
                 "DIVIDE",
                 "GREATER",
                 "LESS",
                 "GREATER_EQUAL",
                 "LESS_EQUAL",
                 "derive",
                 "init",
                 "String",
                 "Integer",
                 "UnlimitedNatural",
                 "Real",
                 "Boolean",
                 "OclAny",
                 "OclVoid",
                 "Invalid",
                 "OclMessage",
                 "and",
                 "or",
                 "xor",
                 "PLUS",
                 "MINUS",
                 "self",
                 "COMMA",
                 "Set",
                 "Bag",
                 "Sequence",
                 "Collection",
                 "OrderedSet",
                 "COLON",
                 "null",
                 "iterate",
                 "forAll",
                 "exists",
                 "isUnique",
                 "any",
                 "one",
                 "collect",
                 "select",
                 "reject",
                 "collectNested",
                 "sortedBy",
                 "closure",
                 "allInstances",
                 "Tuple",
                 "not",
                 "oclIsKindOf",
                 "oclIsTypeOf",
                 "oclAsType",
                 "oclIsNew",
                 "oclIsUndefined",
                 "oclIsInvalid",
                 "oclIsInState",
                 "NUMERIC_OPERATION",
                 "STRING_LITERAL",
                 "INTEGER_LITERAL",
                 "REAL_LITERAL",
                 "true",
                 "false",
                 "OclInvalid",
                 "let",
                 "if",
                 "BAR",
                 "pre",
                 "post",
                 "EOF_TOKEN",
                 "RBRACE",
                 "ATPRE",
                 "inv",
                 "context",
                 "def",
                 "RBRACKET",
                 "COLONCOLON",
                 "SEMICOLON",
                 "endpackage",
                 "in",
                 "endif",
                 "ARROW",
                 "DOT",
                 "DOTDOT",
                 "CARET",
                 "CARETCARET",
                 "then",
                 "else",
                 "implies",
                 "LBRACE",
                 "LBRACKET",
                 "QUESTIONMARK",
                 "package",
                 "INTEGER_RANGE_START",
                 "attr",
                 "oper"
             };

    public final static boolean isValidForParser = true;
}
