/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.parser;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;

public class OCLProblemHandler
extends AbstractProblemHandler {
    private DiagnosticChain diagnostics;

    public OCLProblemHandler(AbstractParser parser) {
        super(parser);
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(problemSeverity.getDiagnosticSeverity(), OCLPlugin.getPluginId(), 1, problemMessage, new Object[]{processingPhase, processingContext});
        if (this.diagnostics == null) {
            this.diagnostics = diagnostic;
        } else {
            this.diagnostics.add((Diagnostic)diagnostic);
        }
    }

    public Diagnostic getDiagnostic() {
        return (Diagnostic)this.diagnostics;
    }

    public void beginParse() {
        this.clearDiagnostic();
    }

    public void beginValidation() {
        this.clearDiagnostic();
    }

    public void clearDiagnostic() {
        this.diagnostics = null;
    }

    public void lexerProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        int leftToken = this.getParser().getTokenIndexAtCharacter(startOffset);
        if (leftToken < 0) {
            leftToken = -leftToken;
        }
        String message = String.valueOf(problemMessage) + " (" + this.getParser().getKind(leftToken) + ") : " + this.getParser().getStartOffset(leftToken) + ":" + this.getParser().getLineNumberOfTokenAt(leftToken) + ":" + this.getParser().getColumnOfTokenAt(leftToken) + ":" + this.getParser().getTokenLength(leftToken) + " " + this.getParser().getTokenText(leftToken);
        this.handleProblem(problemSeverity, ProblemHandler.Phase.LEXER, message, processingContext, startOffset, endOffset);
    }

    public void parserProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        int rightToken;
        int leftToken = this.getParser().getTokenIndexAtCharacter(startOffset);
        int leftTokenLoc = leftToken > (rightToken = this.getParser().getTokenIndexAtCharacter(endOffset)) ? rightToken : leftToken;
        int rightTokenLoc = rightToken;
        int line = this.getParser().getLine(leftTokenLoc) + this.getErrorReportLineOffset();
        if (line > 0) {
            String locInfo = OCLMessages.bind(OCLMessages.ErrorReport_RowColumn, new Object[]{new Integer(this.getParser().getLine(leftTokenLoc) + this.getErrorReportLineOffset()), new Integer(this.getParser().getColumn(leftTokenLoc)), new Integer(this.getParser().getEndLine(rightTokenLoc) + this.getErrorReportLineOffset()), new Integer(this.getParser().getEndColumn(rightTokenLoc))});
            problemMessage = String.valueOf(locInfo) + " " + problemMessage;
        }
        this.handleProblem(problemSeverity, ProblemHandler.Phase.PARSER, problemMessage, processingContext, startOffset, endOffset);
    }
}

