/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.ui.view;

import java.net.URL;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.pulsar.core.SDK;
import org.eclipse.mtj.internal.pulsar.ui.view.ISDKInstallItemLabelProvider;
import org.eclipse.mtj.pulsar.core.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class SDKInstallItemViewer
extends Composite {
    private Text description;
    private Label iconLabel;
    private Object input;
    private ISDKInstallItemLabelProvider labelProvider;
    private Link moreLink;
    private Link siteLink;

    public SDKInstallItemViewer(Composite composite) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        super.setLayout((Layout)gridLayout);
        this.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        this.createControls(this);
    }

    public void setInput(Object object) {
        this.input = object;
        if (this.input != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SDKInstallItemViewer.this.refresh();
                }
            });
        }
    }

    public void setLabelProvider(ISDKInstallItemLabelProvider iSDKInstallItemLabelProvider) {
        this.labelProvider = iSDKInstallItemLabelProvider;
    }

    public void setLayout(Layout layout) {
    }

    private void createControls(Composite composite) {
        GridLayout gridLayout = null;
        this.iconLabel = new Label(composite, 1);
        this.iconLabel.setBackground(composite.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumHeight = 50;
        gridData.heightHint = 50;
        this.iconLabel.setLayoutData((Object)gridData);
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setBackground(composite.getBackground());
        group.setText("Description");
        gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        this.description = new Text((Composite)group, 578);
        this.description.setLayoutData((Object)new GridData(4, 4, true, true));
        this.description.setText("Information not available...");
        this.description.setBackground(composite.getBackground());
        this.description.setEditable(false);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getBackground());
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.siteLink = new Link(composite2, 0);
        this.siteLink.setBackground(composite.getBackground());
        this.siteLink.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.siteLink.setText("<a href=\"\">Web Site...</a>");
        this.siteLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SDKInstallItemViewer.this.openBrowser();
            }
        });
        this.moreLink = new Link(composite2, 0);
        this.moreLink.setBackground(composite.getBackground());
        this.moreLink.setLayoutData((Object)new GridData(131072, 4, false, true));
        this.moreLink.setText("<a href=\"\">More...</a>");
        this.moreLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SDKInstallItemViewer.this.input instanceof SDK) {
                    this.openSDKProperties((SDK)SDKInstallItemViewer.this.input);
                }
            }

            private void openSDKProperties(SDK sDK) {
                PropertyDialogAction propertyDialogAction = new PropertyDialogAction((IShellProvider)new ShellProvider(SDKInstallItemViewer.this.getShell()), (ISelectionProvider)new IUSelectionProvider(sDK.getInstallableUnit()));
                propertyDialogAction.run();
            }
        });
    }

    private void refresh() {
        if (this.labelProvider != null) {
            this.iconLabel.setImage(this.labelProvider.getImage(this.input));
            String string = this.labelProvider.getDescription(this.input);
            if (string != null && string.trim().length() > 0) {
                this.description.setText(string);
            } else {
                this.description.setText("Information not available...");
            }
            String string2 = this.labelProvider.getSite(this.input);
            if (string2 != null) {
                this.siteLink.setEnabled(true);
                this.siteLink.setToolTipText(string2);
            } else {
                this.siteLink.setEnabled(false);
            }
            if (this.input instanceof ISDK) {
                this.moreLink.setEnabled(true);
            } else {
                this.moreLink.setEnabled(false);
            }
        }
    }

    protected void openBrowser() {
        String string = this.labelProvider.getSite(this.input);
        if (string != null) {
            try {
                Activator.openWebBrowser((URL)new URL(string));
            }
            catch (Exception exception) {
                Activator.logError((String)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private class IUSelectionProvider
    implements ISelectionProvider {
        private IInstallableUnit iu;

        public IUSelectionProvider(IInstallableUnit iInstallableUnit) {
            this.iu = iInstallableUnit;
        }

        public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        }

        public ISelection getSelection() {
            return new StructuredSelection((Object)this.iu);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        }

        public void setSelection(ISelection iSelection) {
        }
    }

    private class ShellProvider
    implements IShellProvider {
        private Shell shell;

        public ShellProvider(Shell shell) {
            this.shell = shell;
        }

        public Shell getShell() {
            return this.shell;
        }
    }
}

