/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.uei.DeviceDefinitionManager;
import org.eclipse.mtj.internal.toolkit.uei.Messages;
import org.eclipse.mtj.internal.toolkit.uei.UEIDeviceInternal;
import org.eclipse.mtj.internal.toolkit.uei.UEIPropertiesReader;
import org.eclipse.mtj.internal.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.internal.toolkit.uei.properties.DeviceSpecificProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.DevicesProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UEIDeviceImporter
implements IDeviceImporter {
    public static final String PROP_TOOLKIT_NAME = "org.eclipse.mtj.toolkit.name";
    private static final String UNSUPORTED_CONFIGURATION = "CDC";

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        ArrayList<IDevice> arrayList = null;
        try {
            iProgressMonitor.beginTask(Messages.UEIDeviceImporter_0, 4);
            UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_begin, (Object)file));
            File file2 = this.getEmulatorInDirectory(file);
            iProgressMonitor.worked(1);
            if (file2 != null) {
                UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_emulator, (Object)file2));
                try {
                    Properties properties = this.getUEIEmulatorProperties(file2);
                    iProgressMonitor.worked(1);
                    if (this.isValidUEIProperties(properties)) {
                        UeiPlugin.debugLog(Messages.UEIDeviceImporter_getMatchingDevices_invalid_props);
                        UEIDeviceDefinition uEIDeviceDefinition = this.getDeviceDefinition(properties);
                        iProgressMonitor.worked(1);
                        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_device_def, (Object)uEIDeviceDefinition));
                        if (uEIDeviceDefinition != null) {
                            arrayList = new ArrayList<IDevice>();
                            this.addUEIDevices(arrayList, file2, uEIDeviceDefinition, properties, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            iProgressMonitor.worked(1);
                        }
                    }
                }
                catch (CoreException coreException) {
                    MTJLogger.log((int)4, (String)Messages.UEIDeviceImporter_getMatchingDevices_failed, (Throwable)coreException);
                }
                catch (IOException iOException) {
                    MTJLogger.log((int)4, (String)Messages.UEIDeviceImporter_getMatchingDevices_failed, (Throwable)iOException);
                }
            }
            UeiPlugin.debugLog(String.valueOf(Messages.UEIDeviceImporter_getMatchingDevices_end) + file);
        }
        finally {
            iProgressMonitor.done();
        }
        return arrayList;
    }

    private void addUEIDevices(ArrayList<IDevice> arrayList, File file, UEIDeviceDefinition uEIDeviceDefinition, Properties properties, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        UeiPlugin.debugLog(Messages.UEIDeviceImporter_addUEIDevices_begin);
        String string = properties.getProperty(DevicesProperties.DEVICE_LIST.toString());
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_addUEIDevices_devices, (Object)string));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            iProgressMonitor.beginTask(Messages.UEIDeviceImporter_1, stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                try {
                    IMIDPAPI iMIDPAPI;
                    String string2 = stringTokenizer.nextToken().trim();
                    IMIDPDevice iMIDPDevice = this.createDevice(file, uEIDeviceDefinition, properties, string2);
                    if (iMIDPDevice == null || (iMIDPAPI = iMIDPDevice.getCLDCAPI()) == null || iMIDPAPI.getIdentifier().equals(UNSUPORTED_CONFIGURATION)) continue;
                    iProgressMonitor.subTask(NLS.bind((String)Messages.UEIDeviceImporter_2, (Object[])new String[]{iMIDPDevice.getName(), iMIDPDevice.getSDKName()}));
                    arrayList.add((IDevice)iMIDPDevice);
                    iProgressMonitor.worked(1);
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        }
        UeiPlugin.debugLog(Messages.UEIDeviceImporter_addUEIDevices_end);
    }

    private IMIDPDevice createDevice(File file, UEIDeviceDefinition uEIDeviceDefinition, Properties properties, String string) throws CoreException {
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_createDevice, (Object)string));
        Properties properties2 = this.filterDeviceProperties(properties, string);
        UEIDeviceInternal uEIDeviceInternal = new UEIDeviceInternal(string, properties.getProperty(PROP_TOOLKIT_NAME, "Unknown"), this.getDeviceDescription(properties2, string), properties2, uEIDeviceDefinition, file, this.getPreverifier(file));
        return uEIDeviceInternal;
    }

    private Properties filterDeviceProperties(Properties properties, String string) {
        Properties properties2 = new Properties();
        String string2 = String.valueOf(string) + ".";
        int n = string2.length();
        for (String string3 : properties.keySet()) {
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(n);
            String string5 = properties.getProperty(string3);
            properties2.setProperty(string4, string5);
        }
        return properties2;
    }

    private UEIDeviceDefinition getDeviceDefinition(Properties properties) throws IOException {
        UEIDeviceDefinition uEIDeviceDefinition = null;
        String string = properties.getProperty(PROP_TOOLKIT_NAME, "");
        uEIDeviceDefinition = DeviceDefinitionManager.getInstance().getDeviceDefinition(string);
        return uEIDeviceDefinition;
    }

    private String getDeviceDescription(Properties properties, String string) {
        return properties.getProperty(DeviceSpecificProperties.DESCRIPTION.toString(), string).trim();
    }

    private File getEmulatorInDirectory(File file) {
        File[] fileArray = null;
        File file2 = null;
        try {
            fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().equalsIgnoreCase("emulator.exe") || file.getName().equals("emulator");
                }
            });
        }
        catch (SecurityException securityException) {
            MTJLogger.log((int)4, (String)NLS.bind((String)Messages.UEIDeviceImporter_readAccessDenied, (Object)file), (Throwable)securityException);
        }
        if (fileArray != null && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        return file2;
    }

    private IPreverifier getPreverifier(File file) throws CoreException {
        File file2 = new File(file.getParentFile(), "preverify");
        IPreverifier iPreverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)file2);
        return iPreverifier;
    }

    private Properties getUEIEmulatorProperties(File file) throws CoreException {
        return UEIPropertiesReader.getInstance().getUEIProperties(file);
    }

    private boolean isValidUEIProperties(Properties properties) {
        return properties != null && properties.containsKey(DevicesProperties.DEVICE_LIST.toString());
    }
}

