/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.ajp.AJP13Packet;
import org.mortbay.http.ajp.AJP13ResponsePacket;
import org.mortbay.log.LogFactory;

public class AJP13OutputStream
extends BufferedOutputStream {
    private static Log log = LogFactory.getLog(AJP13OutputStream.class);
    private AJP13ResponsePacket _packet;
    private boolean _complete;
    private boolean _completed;
    private boolean _persistent = true;
    private AJP13ResponsePacket _ajpResponse;

    AJP13OutputStream(OutputStream out, int bufferSize) {
        super(out, bufferSize, 7, 7, 1);
        this.setFixed(true);
        this._packet = new AJP13ResponsePacket(this._buf);
        this._packet.prepare();
        this.setBypassBuffer(false);
        this.setFixed(true);
        this._ajpResponse = new AJP13ResponsePacket(bufferSize);
        this._ajpResponse.prepare();
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        HttpResponse response = (HttpResponse)httpMessage;
        response.setState(3);
        this._ajpResponse.resetData();
        this._ajpResponse.addByte((byte)4);
        this._ajpResponse.addInt(response.getStatus());
        this._ajpResponse.addString(response.getReason());
        int mark = this._ajpResponse.getMark();
        this._ajpResponse.addInt(0);
        int nh = 0;
        Enumeration e1 = response.getFieldNames();
        while (e1.hasMoreElements()) {
            String h = (String)e1.nextElement();
            Enumeration e2 = response.getFieldValues(h);
            while (e2.hasMoreElements()) {
                this._ajpResponse.addHeader(h);
                this._ajpResponse.addString((String)e2.nextElement());
                ++nh;
            }
        }
        if (nh > 0) {
            this._ajpResponse.setInt(mark, nh);
        }
        this._ajpResponse.setDataSize();
        this.write(this._ajpResponse);
        this._ajpResponse.resetData();
    }

    public void write(AJP13Packet packet) throws IOException {
        packet.write(this._out);
    }

    public void flush() throws IOException {
        super.flush();
        if (this._complete && !this._completed) {
            this._completed = true;
            this._packet.resetData();
            this._packet.addByte((byte)5);
            this._packet.addBoolean(this._persistent);
            this._packet.setDataSize();
            this.write(this._packet);
            this._packet.resetData();
        }
    }

    public void close() throws IOException {
        this._complete = true;
        this.flush();
    }

    public void resetStream() {
        this._complete = false;
        this._completed = false;
        super.resetStream();
    }

    public void destroy() {
        if (this._packet != null) {
            this._packet.destroy();
        }
        this._packet = null;
        if (this._ajpResponse != null) {
            this._ajpResponse.destroy();
        }
        this._ajpResponse = null;
        this._out = null;
    }

    public void end() throws IOException {
        this._persistent = false;
    }

    protected void wrapBuffer() throws IOException {
        if (this.size() == 0) {
            return;
        }
        if (this._buf != this._packet.getBuffer()) {
            this._packet = new AJP13ResponsePacket(this._buf);
            this._packet.prepare();
        }
        this.prewrite(this._buf, 0, 7);
        this._packet.resetData();
        this._packet.addByte((byte)3);
        this._packet.setDataSize(this.size() - 4);
        this.postwrite((byte)0);
    }

    protected void bypassWrite(byte[] b, int offset, int length) throws IOException {
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    public void writeTo(OutputStream out) throws IOException {
        int sz = this.size();
        if (sz <= 8192) {
            super.writeTo(out);
        } else {
            int offset = this.preReserve();
            int data = sz - 7;
            while (data > 8185) {
                this._packet.setDataSize(8188);
                if (offset > 0) {
                    System.arraycopy(this._buf, 0, this._buf, offset, 7);
                }
                out.write(this._buf, offset, 8192);
                data -= 8185;
                offset += 8185;
            }
            int len = data + 7;
            this._packet.setDataSize(len - 4);
            if (offset > 0) {
                System.arraycopy(this._buf, 0, this._buf, offset, 7);
            }
            out.write(this._buf, offset, len);
        }
    }
}

