/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class BuildLoggingConfiguration {
    public static final String BUILD_LOGGING_VM_ARG = "mtj.build.logging";
    private static final BuildLoggingConfiguration instance = new BuildLoggingConfiguration();
    private boolean obfuscationOutputEnabled = false;
    private boolean preprocessorTraceEnabled = false;
    private boolean preverifierOutputEnabled = false;
    private boolean preverifierTraceEnabled = false;

    static {
        String string = System.getProperty(BUILD_LOGGING_VM_ARG, "");
        Set<Configuration> set = Configuration.getEnumSet(string);
        if (set.contains((Object)Configuration.obfuscationOutput)) {
            BuildLoggingConfiguration.instance.obfuscationOutputEnabled = true;
        }
        if (set.contains((Object)Configuration.preverifierOutput)) {
            BuildLoggingConfiguration.instance.preverifierOutputEnabled = true;
        }
        if (set.contains((Object)Configuration.preprocessorTrace)) {
            BuildLoggingConfiguration.instance.preprocessorTraceEnabled = true;
        }
        if (set.contains((Object)Configuration.preverifierTrace)) {
            BuildLoggingConfiguration.instance.preverifierTraceEnabled = true;
        }
        if (set.contains((Object)Configuration.all)) {
            BuildLoggingConfiguration.instance.obfuscationOutputEnabled = true;
            BuildLoggingConfiguration.instance.preprocessorTraceEnabled = true;
            BuildLoggingConfiguration.instance.preverifierOutputEnabled = true;
            BuildLoggingConfiguration.instance.preverifierTraceEnabled = true;
        }
    }

    public static synchronized BuildLoggingConfiguration getInstance() {
        return instance;
    }

    private BuildLoggingConfiguration() {
    }

    public boolean isObfuscationOutputEnabled() {
        return this.obfuscationOutputEnabled;
    }

    public boolean isPreprocessorTraceEnabled() {
        return this.preprocessorTraceEnabled;
    }

    public boolean isPreverifierOutputEnabled() {
        return this.preverifierOutputEnabled;
    }

    public boolean isPreverifierTraceEnabled() {
        return this.preverifierTraceEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Configuration {
        all,
        obfuscationOutput,
        preprocessorTrace,
        preverifierOutput,
        preverifierTrace;


        public static Set<Configuration> getEnumSet(String string) {
            Object object;
            if (string == null || string.length() < all.name().length()) {
                return Collections.emptySet();
            }
            String[] stringArray = string.split(",");
            ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                try {
                    Configuration configuration = Configuration.valueOf((String)object);
                    arrayList.add(configuration);
                }
                catch (Exception exception) {
                    MTJLogger.log(2, NLS.bind((String)Messages.BuildLoggingConfiguration_unknown_configuration_error, (Object)object));
                }
                ++n2;
            }
            object = EnumSet.copyOf(arrayList);
            return object;
        }
    }
}

