/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifier;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierParameters;
import org.eclipse.mtj.internal.core.util.Utils;

public class StandardPreverifierFactory {
    private static final String optionNoFp = "-nofp";
    private static final String optionNoFinalize = "-nofinalize";
    private static final String optionNoNative = "-nonative";
    private static final String optionTarget = "-target";
    private static final Pattern PATTERN_NO_FP = Pattern.compile("\\s+-nofp\\s+");
    private static final Pattern PATTERN_NO_FINALIZE = Pattern.compile("\\s+-nofinalize\\s+");
    private static final Pattern PATTERN_NO_NATIVE = Pattern.compile("\\s+-nonative\\s+");
    private static final Pattern PATTERN_TARGET = Pattern.compile("\\s+-target\\s+");
    private static final Map<File, StandardPreverifierParameters> testedPrograms = new HashMap<File, StandardPreverifierParameters>();

    public static IPreverifier createPreverifier(File file) throws CoreException {
        StandardPreverifierParameters standardPreverifierParameters;
        StandardPreverifier standardPreverifier = null;
        if (file != null && (standardPreverifierParameters = StandardPreverifierFactory.getParameters(file)) != null) {
            standardPreverifier = StandardPreverifierFactory.createPreverifier(file, standardPreverifierParameters);
        }
        return standardPreverifier;
    }

    private static StandardPreverifier createPreverifier(File file, StandardPreverifierParameters standardPreverifierParameters) {
        StandardPreverifier standardPreverifier = new StandardPreverifier();
        standardPreverifier.setParameters(standardPreverifierParameters);
        standardPreverifier.setPreverifierExecutable(file);
        return standardPreverifier;
    }

    private static StandardPreverifierParameters getParameters(File file) throws CoreException {
        StandardPreverifierParameters standardPreverifierParameters = testedPrograms.get(file);
        if (standardPreverifierParameters == null && StandardPreverifierFactory.executableExists(file)) {
            standardPreverifierParameters = StandardPreverifierFactory.collectParameters(file);
            testedPrograms.put(file, standardPreverifierParameters);
        }
        return standardPreverifierParameters;
    }

    private static StandardPreverifierParameters collectParameters(File file) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = new String[]{file.toString()};
        Utils.getProcessOutput("Sun Preverifier", stringArray, stringBuffer, stringBuffer2);
        if (StandardPreverifierFactory.find(stringBuffer, PATTERN_TARGET) || StandardPreverifierFactory.find(stringBuffer2, PATTERN_TARGET)) {
            arrayList.add(optionTarget);
            arrayList.add("CLDC1.0");
            arrayList2.add(optionTarget);
            arrayList2.add("CLDC1.1");
        }
        if (StandardPreverifierFactory.find(stringBuffer, PATTERN_NO_FP) || StandardPreverifierFactory.find(stringBuffer2, PATTERN_NO_FP)) {
            arrayList.add(optionNoFp);
        }
        if (StandardPreverifierFactory.find(stringBuffer, PATTERN_NO_FINALIZE) || StandardPreverifierFactory.find(stringBuffer2, PATTERN_NO_FINALIZE)) {
            arrayList.add(optionNoFinalize);
            arrayList2.add(optionNoFinalize);
        }
        if (StandardPreverifierFactory.find(stringBuffer, PATTERN_NO_NATIVE) || StandardPreverifierFactory.find(stringBuffer2, PATTERN_NO_NATIVE)) {
            arrayList.add(optionNoNative);
            arrayList2.add(optionNoNative);
        }
        StandardPreverifierParameters standardPreverifierParameters = new StandardPreverifierParameters();
        standardPreverifierParameters.cldc10 = arrayList.toArray(new String[arrayList.size()]);
        standardPreverifierParameters.cldc11 = arrayList2.toArray(new String[arrayList2.size()]);
        return standardPreverifierParameters;
    }

    private static boolean find(StringBuffer stringBuffer, Pattern pattern) {
        return pattern.matcher(stringBuffer).find();
    }

    private static boolean executableExists(File file) {
        boolean bl = file.exists();
        if (!bl) {
            File file2 = new File(String.valueOf(file.toString()) + ".exe");
            bl = file2.exists();
        }
        return bl;
    }

    private StandardPreverifierFactory() {
    }
}

