/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.midp.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntimeListUtils {
    public static boolean mtjRuntimeListContentsEquals(MTJRuntimeList mTJRuntimeList, MTJRuntimeList mTJRuntimeList2) {
        if (mTJRuntimeList.size() != mTJRuntimeList2.size()) {
            return false;
        }
        for (MTJRuntime mTJRuntime : mTJRuntimeList) {
            int n = mTJRuntimeList2.indexOf(mTJRuntime);
            if (n < 0) {
                return false;
            }
            MTJRuntime mTJRuntime2 = (MTJRuntime)mTJRuntimeList2.get(n);
            if (!MTJRuntimeListUtils.deviceEquals(mTJRuntime, mTJRuntime2)) {
                return false;
            }
            if (!MTJRuntimeListUtils.workspaceSymbolsetsEquals(mTJRuntime.getWorkspaceScopeSymbolSets(), mTJRuntime2.getWorkspaceScopeSymbolSets())) {
                return false;
            }
            if (MTJRuntimeListUtils.symbolSetEquals(mTJRuntime, mTJRuntime2)) continue;
            return false;
        }
        return true;
    }

    public static boolean mtjRuntimeListEquals(MTJRuntimeList mTJRuntimeList, MTJRuntimeList mTJRuntimeList2) {
        if (!MTJRuntimeListUtils.mtjRuntimeListContentsEquals(mTJRuntimeList, mTJRuntimeList2)) {
            return false;
        }
        return mTJRuntimeList.getActiveMTJRuntime().equals(mTJRuntimeList2.getActiveMTJRuntime());
    }

    private static boolean deviceEquals(MTJRuntime mTJRuntime, MTJRuntime mTJRuntime2) {
        return mTJRuntime.getDevice().equals(mTJRuntime2.getDevice());
    }

    public static boolean isMTJRuntimeListDirty(IMTJProject iMTJProject) {
        MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
        boolean bl = true;
        IMetaData iMetaData = MTJCore.createMetaData(iMTJProject.getProject(), ProjectType.MIDLET_SUITE);
        MTJRuntimeList mTJRuntimeList2 = iMetaData.getRuntimeList();
        bl = !MTJRuntimeListUtils.mtjRuntimeListEquals(mTJRuntimeList, mTJRuntimeList2);
        return bl;
    }

    public static boolean isOnlyActiveMTJRuntimeDirty(IMTJProject iMTJProject) {
        MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
        MTJRuntimeList mTJRuntimeList2 = new MetaData(iMTJProject.getProject()).getRuntimeList();
        boolean bl = MTJRuntimeListUtils.mtjRuntimeListContentsEquals(mTJRuntimeList, mTJRuntimeList2);
        return bl;
    }

    private static boolean symbolSetEquals(MTJRuntime mTJRuntime, MTJRuntime mTJRuntime2) {
        ISymbolSet iSymbolSet;
        ISymbolSet iSymbolSet2 = mTJRuntime.getSymbolSet();
        if (!iSymbolSet2.equals(iSymbolSet = mTJRuntime2.getSymbolSet())) {
            return false;
        }
        ArrayList<ISymbol> arrayList = new ArrayList<ISymbol>(iSymbolSet2.getSymbols());
        ArrayList<ISymbol> arrayList2 = new ArrayList<ISymbol>(iSymbolSet.getSymbols());
        for (ISymbol iSymbol : arrayList) {
            if (arrayList2.contains(iSymbol)) continue;
            return false;
        }
        return true;
    }

    public static boolean workspaceSymbolsetsEquals(List<ISymbolSet> list, List<ISymbolSet> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null) {
            return false;
        }
        if (list != null && list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (ISymbolSet iSymbolSet : list) {
            if (list2.contains(iSymbolSet)) continue;
            return false;
        }
        return true;
    }
}

