/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.IModelChangeProviderExtension;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.IModelChangedListenerFilter;
import org.eclipse.mtj.internal.core.ModelChangedEvent;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.IModelTextChangeListener;

public abstract class AbstractEditingModel
extends PlatformObject
implements IEditingModel,
IModelChangeProviderExtension {
    private String fCharset;
    private boolean fDirty;
    private IDocument fDocument;
    private String fInstallLocation;
    private ArrayList<IModelChangedListener> fListeners = new ArrayList();
    private boolean fStale;
    private IResource fUnderlyingResource;
    protected boolean fDisposed;
    protected boolean fInSync = true;
    protected boolean fLoaded = false;
    protected boolean fReconciling;
    protected long fTimestamp;

    public AbstractEditingModel(IDocument iDocument, boolean bl) {
        this.fDocument = iDocument;
        this.fReconciling = bl;
    }

    public void addModelChangedListener(IModelChangedListener iModelChangedListener) {
        if (!this.fListeners.contains(iModelChangedListener)) {
            this.fListeners.add(iModelChangedListener);
        }
    }

    public abstract void adjustOffsets(IDocument var1) throws CoreException;

    public void dispose() {
        this.fDisposed = true;
        this.fListeners.clear();
    }

    public void fireModelChanged(IModelChangedEvent iModelChangedEvent) {
        if (iModelChangedEvent.getChangeType() == 3 && iModelChangedEvent.getOldValue() != null && iModelChangedEvent.getOldValue().equals(iModelChangedEvent.getNewValue())) {
            return;
        }
        this.setDirty(iModelChangedEvent.getChangeType() != 99);
        int n = 0;
        while (n < this.fListeners.size()) {
            this.fListeners.get(n).modelChanged(iModelChangedEvent);
            ++n;
        }
    }

    public void fireModelObjectChanged(Object object, String string, Object object2, Object object3) {
        this.fireModelChanged(new ModelChangedEvent(this, object, string, object2, object3));
    }

    public String getCharset() {
        return this.fCharset != null ? this.fCharset : "UTF-8";
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public String getInstallLocation() {
        if (this.fInstallLocation == null && this.fUnderlyingResource != null) {
            IPath iPath = this.fUnderlyingResource.getProject().getLocation();
            return iPath != null ? iPath.addTrailingSeparator().toString() : null;
        }
        return this.fInstallLocation;
    }

    public IModelTextChangeListener getLastTextChangeListener() {
        int n = this.fListeners.size() - 1;
        while (n >= 0) {
            IModelChangedListener iModelChangedListener = this.fListeners.get(n);
            if (iModelChangedListener instanceof IModelTextChangeListener) {
                return (IModelTextChangeListener)iModelChangedListener;
            }
            --n;
        }
        return null;
    }

    public final long getTimeStamp() {
        return this.fTimestamp;
    }

    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public boolean isEditable() {
        return this.fReconciling;
    }

    public boolean isInSync() {
        return this.fInSync;
    }

    public boolean isLoaded() {
        return this.fLoaded;
    }

    public boolean isReconcilingModel() {
        return this.fReconciling;
    }

    public boolean isStale() {
        return this.fStale;
    }

    public boolean isValid() {
        return this.isLoaded();
    }

    public final void load() throws CoreException {
        try {
            this.load(this.getInputStream(this.getDocument()), false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public final void reconciled(IDocument iDocument) {
        if (this.isReconcilingModel()) {
            try {
                if (this.isStale()) {
                    this.adjustOffsets(iDocument);
                    this.setStale(false);
                } else {
                    this.reload(this.getInputStream(iDocument), false);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
            if (this.isDirty()) {
                this.setDirty(false);
            }
        }
    }

    public final void reload(InputStream inputStream, boolean bl) throws CoreException {
        this.load(inputStream, bl);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[]{this}, null));
    }

    public void removeModelChangedListener(IModelChangedListener iModelChangedListener) {
        this.fListeners.remove(iModelChangedListener);
    }

    public void save(PrintWriter printWriter) {
    }

    public void setCharset(String string) {
        this.fCharset = string;
    }

    public void setDirty(boolean bl) {
        this.fDirty = bl;
    }

    public void setInstallLocation(String string) {
        this.fInstallLocation = string;
    }

    public void setLoaded(boolean bl) {
        this.fLoaded = bl;
    }

    public void setStale(boolean bl) {
        this.fStale = bl;
    }

    public void setUnderlyingResource(IResource iResource) {
        this.fUnderlyingResource = iResource;
    }

    public void transferListenersTo(IModelChangeProviderExtension iModelChangeProviderExtension, IModelChangedListenerFilter iModelChangedListenerFilter) {
        List list = (List)this.fListeners.clone();
        int n = 0;
        while (n < list.size()) {
            IModelChangedListener iModelChangedListener = (IModelChangedListener)list.get(n);
            if (iModelChangedListenerFilter == null || iModelChangedListenerFilter.accept(iModelChangedListener)) {
                iModelChangeProviderExtension.addModelChangedListener(iModelChangedListener);
                this.fListeners.remove(iModelChangedListener);
            }
            ++n;
        }
    }

    protected InputStream getInputStream(IDocument iDocument) throws UnsupportedEncodingException {
        return new BufferedInputStream(new ByteArrayInputStream(iDocument.get().getBytes(this.getCharset())));
    }
}

