/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentRange;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditorContributor;
import org.eclipse.mtj.internal.ui.editor.MTJFormTextEditorContributor;
import org.eclipse.mtj.internal.ui.editor.SourceOutlinePage;
import org.eclipse.mtj.internal.ui.editor.actions.FormatAction;
import org.eclipse.mtj.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.internal.ui.editor.outline.IOutlineContentCreator;
import org.eclipse.mtj.internal.ui.editor.outline.IOutlineSelectionHandler;
import org.eclipse.mtj.internal.ui.editor.text.MTJSelectAnnotationRulerAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public abstract class MTJSourcePage
extends TextEditor
implements IFormPage,
IGotoMarker,
ISelectionChangedListener,
IOutlineContentCreator,
IOutlineSelectionHandler {
    private static String RES_BUNDLE_LOCATION = "org.eclipse.mtj.internal.ui.editor.text.ConstructedMTJEditorMessages";
    private static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle(RES_BUNDLE_LOCATION);
    private Control fControl;
    private MTJFormEditor fEditor;
    protected MTJSourcePageChangedListener fEditorSelectionChangedListener;
    private String fId;
    private int fIndex;
    private InputContext fInputContext;
    protected ISortableContentOutlinePage fOutlinePage;
    private Object fSelection;
    protected ISelectionChangedListener fOutlineSelectionChangedListener;

    public static ResourceBundle getBundleForConstructedKeys() {
        return fgBundleForConstructedKeys;
    }

    public MTJSourcePage(MTJFormEditor mTJFormEditor, String string, String string2) {
        this.fId = string;
        this.initialize(mTJFormEditor);
        IPreferenceStore[] iPreferenceStoreArray = new IPreferenceStore[]{MTJUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(iPreferenceStoreArray));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public IDocumentRange adaptRange(IDocumentRange iDocumentRange) {
        return iDocumentRange;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public ViewerComparator createDefaultOutlineComparator() {
        return null;
    }

    public abstract ViewerComparator createOutlineComparator();

    public abstract ITreeContentProvider createOutlineContentProvider();

    public abstract ILabelProvider createOutlineLabelProvider();

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        Control[] controlArray = composite.getChildren();
        this.fControl = controlArray[controlArray.length - 1];
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IShowInTargetList.class && this.fEditor != null && this.fEditor.getEditorInput() instanceof IFileEditorInput) {
            return this.getShowInTargetList();
        }
        return super.getAdapter(clazz);
    }

    public ISortableContentOutlinePage getContentOutline() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    public FormEditor getEditor() {
        return this.fEditor;
    }

    public String getId() {
        return this.fId;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public InputContext getInputContext() {
        return this.fInputContext;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public Object getOutlineInput() {
        return this.getInputContext().getModel();
    }

    public Control getPartControl() {
        return this.fControl;
    }

    public IDocumentRange getRangeElement(int n, boolean bl) {
        return null;
    }

    public Object getSelection() {
        return this.fSelection;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void initialize(FormEditor formEditor) {
        this.fEditor = (MTJFormEditor)formEditor;
    }

    public boolean isActive() {
        return this.equals(this.fEditor.getActivePageInstance());
    }

    public boolean isEditor() {
        return true;
    }

    public final void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSource() == this.getSelectionProvider()) {
            return;
        }
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.setSelectedObject(iStructuredSelection.getFirstElement());
        } else if (iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            this.setSelectedObject(this.getRangeElement(iTextSelection.getOffset(), false));
        } else {
            this.fSelection = null;
        }
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }

    public void setActive(boolean bl) {
        this.fInputContext.setSourceEditingMode(bl);
    }

    public void setHighlightRange(IDocumentRange iDocumentRange, boolean bl) {
        int n = iDocumentRange.getOffset();
        if (n == -1) {
            this.resetHighlightRange();
            return;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        int n2 = iDocumentRange.getLength();
        this.setHighlightRange(n, n2 == -1 ? 1 : n2, bl);
    }

    public void setIndex(int n) {
        this.fIndex = n;
    }

    public void setInputContext(InputContext inputContext) {
        this.fInputContext = inputContext;
        this.setDocumentProvider(inputContext.getDocumentProvider());
    }

    public void setSelectedRange(IDocumentRange iDocumentRange, boolean bl) {
        int n;
        int n2;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        if (iDocumentRange instanceof IDocumentElementNode && !bl) {
            n2 = ((IDocumentElementNode)iDocumentRange).getXMLTagName().length();
            n = iDocumentRange.getOffset() + 1;
        } else {
            n2 = iDocumentRange.getLength();
            n = iDocumentRange.getOffset();
        }
        iSourceViewer.setSelectedRange(n, n2);
    }

    public void synchronizeOutlinePage() {
        int n = this.getSourceViewer().getSelectedRange().x;
        this.synchronizeOutlinePage(n);
    }

    public abstract void updateSelection(Object var1);

    public void updateSelection(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.updateSelection(iStructuredSelection.getFirstElement());
        }
    }

    private void createContentAssistAction() {
        ContentAssistAction contentAssistAction = new ContentAssistAction(MTJSourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)contentAssistAction);
        this.markAsStateDependentAction("ContentAssist", true);
    }

    private void createQuickOutlineAction() {
        TextOperationAction textOperationAction = new TextOperationAction(MTJSourcePage.getBundleForConstructedKeys(), "QuickOutline.", (ITextEditor)this, 513, true);
        textOperationAction.setActionDefinitionId("org.eclipse.mtj.ui.quickOutline");
        textOperationAction.setText(MTJUIMessages.MTJSourcePage_quickOutlineAction_text);
        textOperationAction.setId("org.eclipse.mtj.ui.quickOutline");
        textOperationAction.setImageDescriptor(MTJUIPluginImages.DESC_OVERVIEW_OBJ);
        this.setAction("org.eclipse.mtj.ui.quickOutline", (IAction)textOperationAction);
    }

    private void synchronizeOutlinePage(IDocumentRange iDocumentRange) {
        this.updateHighlightRange(iDocumentRange);
        this.updateOutlinePageSelection(iDocumentRange);
    }

    protected void createActions() {
        MTJFormEditorContributor mTJFormEditorContributor;
        super.createActions();
        MTJSelectAnnotationRulerAction mTJSelectAnnotationRulerAction = new MTJSelectAnnotationRulerAction(MTJSourcePage.getBundleForConstructedKeys(), "MTJSelectAnnotationRulerAction.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)mTJSelectAnnotationRulerAction);
        MTJFormEditorContributor mTJFormEditorContributor2 = mTJFormEditorContributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (mTJFormEditorContributor instanceof MTJFormTextEditorContributor) {
            MTJFormTextEditorContributor mTJFormTextEditorContributor = (MTJFormTextEditorContributor)mTJFormEditorContributor;
            this.setAction("org.eclipse.mtj.ui.actions.Open", (IAction)mTJFormTextEditorContributor.getHyperlinkAction());
            this.setAction("org.eclipse.mtj.ui.actions.Format", (IAction)mTJFormTextEditorContributor.getFormatAction());
            if (mTJFormTextEditorContributor.supportsContentAssist()) {
                this.createContentAssistAction();
            }
        }
        this.createQuickOutlineAction();
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        SourceOutlinePage sourceOutlinePage = new SourceOutlinePage((MTJFormEditor)this.getEditor(), (IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineComparator(), this.createOutlineComparator());
        this.fOutlinePage = sourceOutlinePage;
        this.fOutlineSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MTJSourcePage.this.updateSelection(selectionChangedEvent);
            }
        };
        this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)sourceOutlinePage);
        this.fEditorSelectionChangedListener = new MTJSourcePageChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        return this.fOutlinePage;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        MTJFormEditorContributor mTJFormEditorContributor;
        MTJFormEditorContributor mTJFormEditorContributor2 = mTJFormEditorContributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (mTJFormEditorContributor instanceof MTJFormTextEditorContributor) {
            MTJFormTextEditorContributor mTJFormTextEditorContributor = (MTJFormTextEditorContributor)mTJFormEditorContributor;
            HyperlinkAction hyperlinkAction = mTJFormTextEditorContributor.getHyperlinkAction();
            iMenuManager.add((IAction)hyperlinkAction);
            FormatAction formatAction = mTJFormTextEditorContributor.getFormatAction();
            if (this.isEditable() && formatAction != null && formatAction.isEnabled()) {
                iMenuManager.add((IAction)formatAction);
            }
        }
        super.editorContextMenuAboutToShow(iMenuManager);
    }

    protected IDocumentRange findNode(IDocumentElementNode iDocumentElementNode, int n, boolean bl) {
        return this.findNode(new Object[]{iDocumentElementNode}, n, bl);
    }

    protected IDocumentRange findNode(Object[] objectArray, int n, boolean bl) {
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray2[n3];
            IDocumentElementNode iDocumentElementNode = (IDocumentElementNode)object;
            if (iDocumentElementNode.getOffset() <= n && n < iDocumentElementNode.getOffset() + iDocumentElementNode.getLength()) {
                IDocumentTextNode iDocumentTextNode;
                if (!bl) {
                    return iDocumentElementNode;
                }
                if (iDocumentElementNode.getOffset() < n && n <= iDocumentElementNode.getOffset() + iDocumentElementNode.getXMLTagName().length() + 1) {
                    return iDocumentElementNode;
                }
                IDocumentAttributeNode[] iDocumentAttributeNodeArray = iDocumentElementNode.getNodeAttributes();
                if (iDocumentAttributeNodeArray != null) {
                    IDocumentAttributeNode[] iDocumentAttributeNodeArray2 = iDocumentAttributeNodeArray;
                    int n4 = iDocumentAttributeNodeArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        iDocumentTextNode = iDocumentAttributeNodeArray2[n5];
                        if (iDocumentTextNode.getNameOffset() <= n && n <= iDocumentTextNode.getValueOffset() + iDocumentTextNode.getValueLength()) {
                            return iDocumentTextNode;
                        }
                        ++n5;
                    }
                }
                if ((iDocumentTextNode = iDocumentElementNode.getTextNode()) != null && iDocumentTextNode.getOffset() <= n && n < iDocumentTextNode.getOffset() + iDocumentTextNode.getLength()) {
                    return iDocumentTextNode;
                }
                IDocumentElementNode[] iDocumentElementNodeArray = iDocumentElementNode.getChildNodes();
                if (iDocumentElementNodeArray != null) {
                    IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray;
                    int n6 = iDocumentElementNodeArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IDocumentElementNode iDocumentElementNode2 = iDocumentElementNodeArray2[n7];
                        if (iDocumentElementNode2.getOffset() <= n && n < iDocumentElementNode2.getOffset() + iDocumentElementNode2.getLength()) {
                            return this.findNode(iDocumentElementNode2, n, bl);
                        }
                        ++n7;
                    }
                }
                return iDocumentElementNode;
            }
            ++n3;
        }
        return null;
    }

    protected IDocumentRange findRange() {
        return null;
    }

    protected void firePropertyChange(int n) {
        if (n == 257) {
            this.fEditor.fireSaveNeeded(this.getEditorInput(), true);
        }
        super.firePropertyChange(n);
    }

    protected IShowInTargetList getShowInTargetList() {
        return new IShowInTargetList(){

            public String[] getShowInTargetIds() {
                return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
            }
        };
    }

    protected void handleSelectionChangedSourcePage(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            int n = iTextSelection.getOffset();
            IDocumentRange iDocumentRange = this.getRangeElement(n, false);
            this.setSelectedObject(iDocumentRange);
            this.synchronizeOutlinePage(iDocumentRange);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.mtj.ui.mtjEditorContext"});
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected void setSelectedObject(Object object) {
        this.fSelection = object;
    }

    protected void synchronizeOutlinePage(int n) {
        IDocumentRange iDocumentRange = this.getRangeElement(n, false);
        this.synchronizeOutlinePage(iDocumentRange);
    }

    protected void updateHighlightRange(IDocumentRange iDocumentRange) {
        if (iDocumentRange != null) {
            this.setHighlightRange(iDocumentRange, false);
        } else {
            this.resetHighlightRange();
        }
    }

    protected void updateOutlinePageSelection(Object object) {
        if (MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked")) {
            if (!(this.fOutlinePage instanceof SourceOutlinePage)) {
                return;
            }
            SourceOutlinePage sourceOutlinePage = (SourceOutlinePage)this.fOutlinePage;
            sourceOutlinePage.removeAllSelectionChangedListeners();
            if (object != null) {
                sourceOutlinePage.setSelection((ISelection)new StructuredSelection(object));
            } else {
                sourceOutlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            sourceOutlinePage.addAllSelectionChangedListeners();
        }
    }

    public class MTJSourcePageChangedListener
    implements ISelectionChangedListener {
        public void install(ISelectionProvider iSelectionProvider) {
            if (iSelectionProvider != null) {
                if (iSelectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                    iPostSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            MTJSourcePage.this.handleSelectionChangedSourcePage(selectionChangedEvent);
        }

        public void uninstall(ISelectionProvider iSelectionProvider) {
            if (iSelectionProvider != null) {
                if (iSelectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                    iPostSelectionProvider.removePostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }
    }
}

