/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BuildPropertiesPage
extends FormPage
implements MTJBuildPropertiesChangeListener {
    private static final String PAGE_TITLE = MTJUIMessages.BuildPropertiesPage_pageTitle;
    private static final String PAGE_ID = "buildPropertiesPage";
    private MTJBuildProperties properties;
    private IMTJProject mtjProject;
    private MTJRuntime currentRuntime;
    private ContainerCheckedTreeViewer resourcesViewer;
    private ComboViewer configurationsViewer;
    private boolean dirty;

    public BuildPropertiesPage(FormEditor formEditor, MTJBuildProperties mTJBuildProperties) {
        super(formEditor, PAGE_ID, PAGE_TITLE);
        this.properties = mTJBuildProperties;
        this.properties.addPropertiesChangeListener((MTJBuildPropertiesChangeListener)this);
        this.mtjProject = mTJBuildProperties.getMTJProject();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        ScrolledForm scrolledForm = iManagedForm.getForm();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setText(this.getTitle());
        Composite composite = scrolledForm.getBody();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        this.createConfigurationsSection(iManagedForm, composite);
        this.createResourcesSection(iManagedForm, composite);
        scrolledForm.reflow(true);
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (bl) {
            this.configurationsViewer.refresh();
            this.updateViewer();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            this.properties.store();
            this.setDirty(false);
            this.mtjProject.getProject().build(6, "org.eclipse.mtj.core.packageBuilder", new HashMap(), iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJLogger.log((int)4, (Throwable)iOException);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }

    private void createConfigurationsSection(IManagedForm iManagedForm, Composite composite) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, false);
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.BuildPropertiesPage_runtimeSectionTitle, MTJUIMessages.BuildPropertiesPage_runtimeSectionDetails, gridData);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Combo combo = new Combo(composite2, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.setFocus();
        this.configurationsViewer = new ComboViewer(combo);
        this.configurationsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                ArrayList arrayList = new ArrayList();
                if (object instanceof MTJRuntimeList) {
                    MTJRuntimeList mTJRuntimeList = (MTJRuntimeList)object;
                    arrayList.addAll(mTJRuntimeList);
                }
                return arrayList.toArray();
            }

            public void dispose() {
            }
        });
        this.configurationsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                String string = null;
                if (object instanceof MTJRuntime) {
                    MTJRuntime mTJRuntime = (MTJRuntime)object;
                    string = mTJRuntime.getName();
                }
                return string;
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPropertiesPage.this.updateViewer();
            }
        });
        MTJRuntimeList mTJRuntimeList = this.mtjProject.getRuntimeList();
        this.currentRuntime = mTJRuntimeList.getActiveMTJRuntime();
        this.configurationsViewer.setInput((Object)mTJRuntimeList);
        this.configurationsViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentRuntime));
    }

    private void updateModel() {
        Object[] objectArray;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        Object[] objectArray2 = objectArray = this.resourcesViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof IResource) {
                arrayList.add((IResource)object);
            }
            ++n2;
        }
        this.properties.setBuildProperty(this.currentRuntime, arrayList.toArray(new IResource[arrayList.size()]));
    }

    private void updateViewer() {
        Object[] objectArray;
        ISelection iSelection = this.configurationsViewer.getSelection();
        if (!(iSelection instanceof IStructuredSelection) || iSelection.isEmpty()) {
            this.currentRuntime = this.mtjProject.getRuntimeList().getActiveMTJRuntime();
            this.configurationsViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentRuntime));
        } else {
            objectArray = (Object[])iSelection;
            this.currentRuntime = (MTJRuntime)objectArray.getFirstElement();
        }
        objectArray = this.properties.getBuildProperty(this.currentRuntime);
        this.resourcesViewer.setCheckedElements(objectArray);
    }

    private void createResourcesSection(IManagedForm iManagedForm, Composite composite) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.BuildPropertiesPage_resourcesSectionTitle, MTJUIMessages.BuildPropertiesPage_resourcesSectionDescription, gridData);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Tree tree = new Tree(composite2, 2082);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resourcesViewer = new ContainerCheckedTreeViewer(tree);
        this.resourcesViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.resourcesViewer.setInput((Object)this.mtjProject.getProject());
        this.resourcesViewer.setFilters(new ViewerFilter[]{new SourceFolderFilter(this.mtjProject.getJavaProject())});
        this.resourcesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                BuildPropertiesPage.this.updateModel();
                BuildPropertiesPage.this.setDirty(true);
            }
        });
        this.updateViewer();
    }

    private Composite createSection(IManagedForm iManagedForm, Composite composite, String string, String string2, GridData gridData) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 384);
        if (string != null) {
            section.setText(string);
        }
        if (string2 != null) {
            section.setDescription(string2);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = formToolkit.createComposite((Composite)section, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)composite2);
        return composite2;
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
        this.getEditor().editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    public void propertiesChanged(final MTJBuildProperties mTJBuildProperties) {
        if (this.isActive() && this.currentRuntime != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Object[] objectArray = mTJBuildProperties.getBuildProperty(BuildPropertiesPage.this.currentRuntime);
                    BuildPropertiesPage.this.resourcesViewer.refresh();
                    BuildPropertiesPage.this.resourcesViewer.setCheckedElements(objectArray);
                    BuildPropertiesPage.this.setDirty(false);
                }
            });
        }
    }

    private class SourceFolderFilter
    extends ViewerFilter {
        private IPath[] sources;

        public SourceFolderFilter(IJavaProject iJavaProject) {
            ArrayList<IPath> arrayList = new ArrayList<IPath>();
            try {
                IClasspathEntry[] iClasspathEntryArray;
                IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                    if (iClasspathEntry.getEntryKind() == 3) {
                        arrayList.add(iClasspathEntry.getPath());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                MTJLogger.log((int)4, (Throwable)javaModelException);
            }
            this.sources = arrayList.toArray(new IPath[arrayList.size()]);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = false;
            if (object2 instanceof IResource) {
                IResource iResource = (IResource)object2;
                IPath iPath = iResource.getFullPath();
                IPath[] iPathArray = this.sources;
                int n = this.sources.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath iPath2 = iPathArray[n2];
                    if (iPath2.isPrefixOf(iPath)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            return bl;
        }
    }
}

