/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build.pages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BuildPropertiesSourcePage
extends FormPage
implements MTJBuildPropertiesChangeListener {
    private MTJBuildProperties properties;
    private boolean dirty;
    private Text text;

    public BuildPropertiesSourcePage(FormEditor formEditor, MTJBuildProperties mTJBuildProperties) {
        super(formEditor, "buildPropertiesPageSource", "build.properties");
        this.properties = mTJBuildProperties;
        this.properties.addPropertiesChangeListener((MTJBuildPropertiesChangeListener)this);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        ScrolledForm scrolledForm = iManagedForm.getForm();
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        Composite composite = scrolledForm.getBody();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        this.createTextArea(iManagedForm, composite);
        scrolledForm.reflow(true);
    }

    private void createTextArea(IManagedForm iManagedForm, Composite composite) {
        this.text = new Text(composite, 770);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BuildPropertiesSourcePage.this.updateModel();
                BuildPropertiesSourcePage.this.setDirty(true);
            }
        });
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (bl) {
            this.updateViewer();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.setDirty(false);
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
        this.getEditor().editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    private void updateModel() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.text.getText().getBytes());
            this.properties.load((InputStream)byteArrayInputStream);
        }
        catch (IOException iOException) {
            MTJLogger.log((int)4, (Throwable)iOException);
        }
    }

    private void updateViewer() {
        this.text.setText(this.properties.getContent().toString());
        this.setDirty(false);
    }

    public void propertiesChanged(MTJBuildProperties mTJBuildProperties) {
        if (this.isActive()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    BuildPropertiesSourcePage.this.updateViewer();
                }
            });
        }
    }
}

