/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeChangeListener;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeDeviceChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeNameChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeWorkspaceSymbolSetsChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.actions.exporting.AntennaBuildExportAction;
import org.eclipse.mtj.internal.ui.actions.packaging.CreateObfuscatedPackageAction;
import org.eclipse.mtj.internal.ui.actions.packaging.CreatePackageAction;
import org.eclipse.mtj.internal.ui.configurations.ConfigManageComponent;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.preferences.ExtendedStringFieldEditor;
import org.eclipse.mtj.ui.editors.jad.JADPropertiesEditorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class OverviewEditorPage
extends JADPropertiesEditorPage
implements IPropertyChangeListener,
IMTJRuntimeListChangeListener,
IMTJRuntimeChangeListener {
    private static final String OVERVIEW_PAGEID = "overview";
    private ConfigManageComponent configManager;
    private String loadedJarUrl;
    private IMidletSuiteProject midletProject;
    private IJavaProject project = JavaCore.create((IProject)((JADFormEditor)this.getEditor()).getJadFile().getProject());

    public OverviewEditorPage(JADFormEditor jADFormEditor) {
        super(jADFormEditor, OVERVIEW_PAGEID, MTJUIMessages.OverviewEditorPage_title);
        this.midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.project);
    }

    public void activeMTJRuntimeSwitched(SwitchActiveMTJRuntimeEvent switchActiveMTJRuntimeEvent) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void mtjRuntimeAdded(AddMTJRuntimeEvent addMTJRuntimeEvent) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void mtjRuntimeRemoved(RemoveMTJRuntimeEvent removeMTJRuntimeEvent) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void deviceChanged(MTJRuntimeDeviceChangeEvent mTJRuntimeDeviceChangeEvent) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void dispose() {
        super.dispose();
        if (this.isDirty()) {
            this.configManager.performCancel();
        }
        this.configManager.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        String string = this.getPreferenceStore().getString("MIDlet-Jar-URL");
        if (!string.equals(this.loadedJarUrl)) {
            ((JADFormEditor)this.getEditor()).setCleanRequired(true);
        }
        IDevice iDevice = this.configManager.getActiveConfiguration().getDevice();
        if (this.midletProject != null && iDevice != null) {
            try {
                this.midletProject.refreshClasspath(iProgressMonitor);
                this.configManager.performFinish();
                this.midletProject.saveMetaData();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    public String getTitle() {
        return MTJUIMessages.OverviewEditorPage_title;
    }

    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
        String string = (String)hyperlinkEvent.getHref();
        IWorkbenchPart iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (string.equals("package")) {
            new CreatePackageAction().run(this.project, iWorkbenchPart);
        } else if (string.equals("obfuscate")) {
            new CreateObfuscatedPackageAction().run(this.project, iWorkbenchPart);
        } else if (string.equals("antenna")) {
            new AntennaBuildExportAction().run(this.project, iWorkbenchPart);
        } else if (string.startsWith("launchShortcut.")) {
            this.handleLaunchShortcut(string);
        }
    }

    public void nameChanged(MTJRuntimeNameChangeEvent mTJRuntimeNameChangeEvent) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
            if (propertyChangeEvent.getSource() instanceof ExtendedStringFieldEditor) {
                String string = ((FieldEditor)propertyChangeEvent.getSource()).getLabelText();
                Text text = ((ExtendedStringFieldEditor)((Object)propertyChangeEvent.getSource())).getFieldEditorTextControl();
                if (propertyChangeEvent.getNewValue().equals("")) {
                    this.getErrorMessageManager().addMessage((Object)("textLength_" + string), MTJUIMessages.OverviewEditorPage_empty_field_error_msg, null, 3, (Control)text);
                } else {
                    this.getErrorMessageManager().removeMessage((Object)("textLength_" + string), (Control)text);
                }
            }
            this.setDirty(true);
        }
    }

    public void symbolSetChanged() {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void workspaceScopeSymbolSetsChanged(MTJRuntimeWorkspaceSymbolSetsChangeEvent mTJRuntimeWorkspaceSymbolSetsChangeEvent) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    private void createDebuginSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, MTJUIMessages.OverviewEditorPage_debugging_section_title);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, MTJUIMessages.overviewPage_launchsection_debuglinks, formToolkit, this);
        formText.setImage("debugMidlet", MTJUIPluginImages.DESC_DEBUG_MIDLET.createImage());
        formText.setImage("debugjad", MTJUIPluginImages.DESC_DEBUG_JAD.createImage());
        formText.setImage("debugOta", MTJUIPluginImages.DESC_DEBUG_OTA.createImage());
        section.setClient((Control)composite2);
    }

    private void createExportingSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, MTJUIMessages.OverviewEditorPage_exporting_section_title);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, MTJUIMessages.overviewPage_exporting, formToolkit, this);
        formText.setImage("antenna", MTJUIPluginImages.DESC_ANT.createImage());
        section.setClient((Control)composite2);
    }

    private void createOverviewSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticBasicSection(formToolkit, composite, MTJUIMessages.overviewPage_requiredsection_title, MTJUIMessages.overviewPage_requiredsection_description);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(iManagedForm, composite2, this);
        section.setClient((Control)composite2);
    }

    private void createPackagingSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, MTJUIMessages.OverviewEditorPage_packaging_section_title);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, MTJUIMessages.overviewPage_deploying, formToolkit, this);
        formText.setImage("package", MTJUIPluginImages.DESC_PACKAGE.createImage());
        formText.setImage("obfuscate", MTJUIPluginImages.DESC_PACKAGE_OBFUSCATED.createImage());
        section.setClient((Control)composite2);
    }

    private void createRunningSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticSection(formToolkit, composite, MTJUIMessages.OverviewEditorPage_running_section_title);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        FormText formText = this.createClient(composite2, MTJUIMessages.overviewPage_launchsection_runlinks, formToolkit, this);
        formText.setImage("runMidlet", MTJUIPluginImages.DESC_RUN_MIDLET.createImage());
        formText.setImage("runjad", MTJUIPluginImages.DESC_RUN_JAD.createImage());
        formText.setImage("runOta", MTJUIPluginImages.DESC_RUN_OTA.createImage());
        section.setClient((Control)composite2);
    }

    private void createRuntimeSection(IManagedForm iManagedForm, Composite composite, FormToolkit formToolkit) {
        Section section = this.createStaticBasicSection(formToolkit, composite, MTJUIMessages.overviewPage_runtimesection_title, MTJUIMessages.overviewPage_runtimesection_description);
        Composite composite2 = this.createStaticSectionClient(formToolkit, (Composite)section);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(true, 1));
        this.createRuntimeSectionContent(iManagedForm, composite2, this);
        section.setClient((Control)composite2);
    }

    private void createRuntimeSectionContent(IManagedForm iManagedForm, Composite composite, OverviewEditorPage overviewEditorPage) {
        this.configManager = new ConfigManageComponent(this.midletProject);
        this.configManager.setIncludeGroup(false);
        this.configManager.createContents(composite);
        this.configManager.setConfigurationsChangeListener(this);
        this.configManager.setConfigurationChangeListener(this);
    }

    private void fillEditorPageBody(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = iManagedForm.getForm().getBody();
        composite.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        composite2.setLayoutData((Object)new TableWrapData(256));
        this.createOverviewSection(iManagedForm, composite2, formToolkit);
        this.createPackagingSection(iManagedForm, composite2, formToolkit);
        this.createExportingSection(iManagedForm, composite2, formToolkit);
        Composite composite3 = formToolkit.createComposite(composite);
        composite3.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        composite3.setLayoutData((Object)new TableWrapData(256));
        this.createRunningSection(iManagedForm, composite3, formToolkit);
        this.createDebuginSection(iManagedForm, composite3, formToolkit);
        this.createRuntimeSection(iManagedForm, composite3, formToolkit);
    }

    private void handleLaunchShortcut(String string) {
        IConfigurationElement[] iConfigurationElementArray;
        int n = (string = string.substring(15)).indexOf(46);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n2 = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
            if (string3.equals(iConfigurationElement.getAttribute("id"))) {
                try {
                    ILaunchShortcut iLaunchShortcut = (ILaunchShortcut)iConfigurationElement.createExecutableExtension("class");
                    iLaunchShortcut.launch((ISelection)new StructuredSelection((Object)this.project), string2);
                }
                catch (CoreException coreException) {}
            }
            ++n3;
        }
    }

    protected void addContextHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_JADRequiredPropertiesEditorPage");
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getTitle());
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        this.createErrorMessageHandler(iManagedForm);
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action(MTJUIMessages.OverviewEditorPage_help_action){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                }
            };
            action.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            iToolBarManager.add((IAction)action);
        }
        scrolledForm.updateToolBar();
        this.fillEditorPageBody(iManagedForm);
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/overview.html";
    }

    protected String getSectionDescription() {
        return "";
    }

    protected String getSectionTitle() {
        return "";
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.loadedJarUrl = this.getPreferenceStore().getString("MIDlet-Jar-URL");
    }
}

