/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.internal.core.IMTJCoreConstants;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.preferences.MultiValuedTableFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ObfuscationPreferencePage
extends FieldEditorPreferencePage
implements IEmbeddableWorkbenchPreferencePage,
IMTJCoreConstants {
    public static final String ID = "org.eclipse.mtj.ui.preferences.ObfuscationPreferencePage";
    private boolean embeddedInProperties;
    private Button specifiedArgumentsButton;
    private Text specifiedArgumentsText;

    public ObfuscationPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public ObfuscationPreferencePage(boolean bl, IPreferenceStore iPreferenceStore) {
        super(1);
        this.embeddedInProperties = bl;
        this.setPreferenceStore(iPreferenceStore);
        if (!bl) {
            this.setDescription(MTJUIMessages.ObfuscationPreferencePage_description);
        }
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        if (!this.embeddedInProperties) {
            this.addField((FieldEditor)new ProguardDirectoryFieldEditor("proguard_dir", MTJUIMessages.ObfuscationPreferencePage_proguard_root_directory, composite));
        }
        Font font = composite.getFont();
        this.specifiedArgumentsButton = new Button(composite, 32);
        this.specifiedArgumentsButton.setText(MTJUIMessages.ObfuscationPreferencePage_specified_arguments);
        this.specifiedArgumentsButton.setFont(font);
        this.specifiedArgumentsText = new Text(composite, 2052);
        this.specifiedArgumentsText.setFont(font);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.specifiedArgumentsText.setLayoutData((Object)gridData);
        this.specifiedArgumentsText.setEnabled(false);
        this.specifiedArgumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ObfuscationPreferencePage.this.specifiedArgumentsText.setEnabled(ObfuscationPreferencePage.this.specifiedArgumentsButton.getSelection());
            }
        });
        this.addField(new MultiValuedTableFieldEditor("proguard_keep", MTJUIMessages.ObfuscationPreferencePage_proguard_keep_expressions, composite));
        this.addProguardNotes(composite, font);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        super.performDefaults();
        this.setState(false, "-dontusemixedcaseclassnames -dontnote -defaultpackage ''");
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = this.specifiedArgumentsButton.getSelection();
        iPreferenceStore.setValue("proguard_use_specified", bl);
        iPreferenceStore.setValue("proguard_options", this.specifiedArgumentsText.getText());
        return super.performOk();
    }

    private void addProguardNotes(Composite composite, Font font) {
        Label label = new Label(composite, 0);
        label.setFont(font);
        label.setText(MTJUIMessages.ObfuscationPreferencePage_proguard_note);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void setState(boolean bl, String string) {
        this.specifiedArgumentsButton.setSelection(bl);
        this.specifiedArgumentsText.setText(string);
        this.specifiedArgumentsText.setEnabled(bl);
    }

    protected Control createContents(Composite composite) {
        if (this.embeddedInProperties) {
            this.noDefaultAndApplyButton();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_ObfuscationPreferencePage");
        return super.createContents(composite);
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.setState(iPreferenceStore.getBoolean("proguard_use_specified"), iPreferenceStore.getString("proguard_options"));
    }

    private class ProguardDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public ProguardDirectoryFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
        }

        protected boolean doCheckState() {
            boolean bl = false;
            File file = null;
            String string = null;
            string = this.getStringValue();
            if (string != null && string.trim().length() > 0) {
                file = new File(string);
                if (file.isDirectory()) {
                    if (this.isProguardFolder(file)) {
                        bl = true;
                    } else {
                        this.setErrorMessage(NLS.bind((String)MTJUIMessages.ObfuscationPreferencePage_couldNotFindProguardJAr, (Object)file.getAbsolutePath()));
                    }
                } else {
                    this.setErrorMessage(MTJUIMessages.ObfuscationPreferencePage_NotAFolder);
                }
            } else {
                bl = true;
            }
            return bl;
        }

        private boolean isProguardFolder(File file) {
            String string = NLS.bind((String)"lib{0}proguard.jar", (Object)File.separator);
            File file2 = new File(file, string);
            return file2.exists();
        }
    }
}

