/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.io.IOException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public class PluginPreferenceStore
implements IPersistentPreferenceStore {
    private boolean listenerAdded = false;
    private Plugin owner;
    private Preferences prefs = null;
    private ListenerList listeners = new ListenerList();
    private boolean silentRunning = false;

    public PluginPreferenceStore(Plugin plugin, Preferences preferences) {
        this.owner = plugin;
        this.prefs = preferences;
    }

    void initialize() {
        if (this.prefs != null) {
            return;
        }
        if (!this.listenerAdded) {
            this.prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                    if (!PluginPreferenceStore.this.silentRunning) {
                        PluginPreferenceStore.this.firePropertyChangeEvent(propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                }
            });
            this.listenerAdded = true;
        }
    }

    private Preferences getPrefs() {
        if (this.prefs == null) {
            this.initialize();
        }
        return this.prefs;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object[] objectArray = this.listeners.getListeners();
        final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Preference Change Error"){

                public void run() {
                    iPropertyChangeListener.propertyChange(propertyChangeEvent);
                }
            });
            ++n;
        }
    }

    public boolean contains(String string) {
        return this.getPrefs().contains(string);
    }

    public boolean getBoolean(String string) {
        return this.getPrefs().getBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        return this.getPrefs().getDefaultBoolean(string);
    }

    public double getDefaultDouble(String string) {
        return this.getPrefs().getDefaultDouble(string);
    }

    public float getDefaultFloat(String string) {
        return this.getPrefs().getDefaultFloat(string);
    }

    public int getDefaultInt(String string) {
        return this.getPrefs().getDefaultInt(string);
    }

    public long getDefaultLong(String string) {
        return this.getPrefs().getDefaultLong(string);
    }

    public String getDefaultString(String string) {
        return this.getPrefs().getDefaultString(string);
    }

    public double getDouble(String string) {
        return this.getPrefs().getDouble(string);
    }

    public float getFloat(String string) {
        return this.getPrefs().getFloat(string);
    }

    public int getInt(String string) {
        return this.getPrefs().getInt(string);
    }

    public long getLong(String string) {
        return this.getPrefs().getLong(string);
    }

    public String getString(String string) {
        return this.getPrefs().getString(string);
    }

    public boolean isDefault(String string) {
        return this.getPrefs().isDefault(string);
    }

    public boolean needsSaving() {
        return this.getPrefs().needsSaving();
    }

    public void putValue(String string, String string2) {
        try {
            this.silentRunning = true;
            this.getPrefs().setValue(string, string2);
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setDefault(String string, double d) {
        this.getPrefs().setDefault(string, d);
    }

    public void setDefault(String string, float f) {
        this.getPrefs().setDefault(string, f);
    }

    public void setDefault(String string, int n) {
        this.getPrefs().setDefault(string, n);
    }

    public void setDefault(String string, long l) {
        this.getPrefs().setDefault(string, l);
    }

    public void setDefault(String string, String string2) {
        this.getPrefs().setDefault(string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.getPrefs().setDefault(string, bl);
    }

    public void setToDefault(String string) {
        this.getPrefs().setToDefault(string);
    }

    public void setValue(String string, double d) {
        this.getPrefs().setValue(string, d);
    }

    public void setValue(String string, float f) {
        this.getPrefs().setValue(string, f);
    }

    public void setValue(String string, int n) {
        this.getPrefs().setValue(string, n);
    }

    public void setValue(String string, long l) {
        this.getPrefs().setValue(string, l);
    }

    public void setValue(String string, String string2) {
        this.getPrefs().setValue(string, string2);
    }

    public void setValue(String string, boolean bl) {
        this.getPrefs().setValue(string, bl);
    }

    public void save() throws IOException {
        this.owner.savePluginPreferences();
    }
}

