/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFoldingStructureProvider
implements IFoldingStructureProvider,
IModelChangedListener {
    private MTJSourcePage fEditor;
    private IEditingModel fModel;

    public AbstractFoldingStructureProvider(MTJSourcePage mTJSourcePage, IEditingModel iEditingModel) {
        this.fEditor = mTJSourcePage;
        this.fModel = iEditingModel;
    }

    @Override
    public void initialize() {
        this.update();
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        this.update();
    }

    public void reconciled(IDocument iDocument) {
        this.update();
    }

    public void update() {
        ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (projectionAnnotationModel == null) {
            return;
        }
        HashSet<Position> hashSet = new HashSet<Position>();
        try {
            this.addFoldingRegions(hashSet, this.fModel);
            this.updateFoldingRegions(projectionAnnotationModel, hashSet);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void updateFoldingRegions(ProjectionAnnotationModel projectionAnnotationModel, Set<Position> set) {
        Annotation[] annotationArray = this.computeDifferences(projectionAnnotationModel, set);
        HashMap<ProjectionAnnotation, Position> hashMap = new HashMap<ProjectionAnnotation, Position>();
        for (Position position : set) {
            hashMap.put(new ProjectionAnnotation(false), position);
        }
        if (annotationArray.length != 0 || hashMap.size() != 0) {
            projectionAnnotationModel.modifyAnnotations(annotationArray, hashMap, new Annotation[0]);
        }
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel projectionAnnotationModel, Set<Position> set) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ProjectionAnnotation)) continue;
            Position position = projectionAnnotationModel.getPosition((Annotation)e);
            if (set.contains(position)) {
                set.remove(position);
                continue;
            }
            arrayList.add(e);
        }
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }
}

