/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;

public class HyperlinkAction
extends Action
implements MouseListener,
KeyListener {
    protected IHyperlinkDetector fDetector;
    protected IHyperlink fLink;
    protected StyledText fStyledText;

    public HyperlinkAction() {
        this.setImageDescriptor(MTJUIPluginImages.DESC_LINK_OBJ);
        this.setEnabled(false);
    }

    public boolean detectHyperlink() {
        this.fLink = null;
        if (!this.hasDetector() || this.isTextDisposed()) {
            return false;
        }
        Point point = this.fStyledText.getSelection();
        IHyperlink[] iHyperlinkArray = this.fDetector.detectHyperlinks(null, (IRegion)new Region(point.x, point.y - point.x), false);
        if (iHyperlinkArray == null || iHyperlinkArray.length == 0) {
            return false;
        }
        this.fLink = iHyperlinkArray[0];
        return true;
    }

    public void generateActionText() {
        String string = MTJUIMessages.HyperlinkAction_text;
        this.setText(string);
        this.setToolTipText(string);
    }

    public IHyperlink getHyperLink() {
        return this.fLink;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    public void run() {
        if (this.fLink != null) {
            this.fLink.open();
        }
    }

    public void setTextEditor(ITextEditor iTextEditor) {
        StyledText styledText;
        StyledText styledText2 = styledText = iTextEditor instanceof MTJSourcePage ? ((MTJSourcePage)iTextEditor).getViewer().getTextWidget() : null;
        if (this.fStyledText != null && this.fStyledText.equals(styledText)) {
            return;
        }
        this.removeListeners();
        this.fStyledText = styledText;
        this.fDetector = iTextEditor instanceof MTJSourcePage ? (IHyperlinkDetector)((MTJSourcePage)iTextEditor).getAdapter(IHyperlinkDetector.class) : null;
        this.addListeners();
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    private boolean isTextDisposed() {
        return this.fStyledText == null || this.fStyledText.isDisposed();
    }

    protected void addListeners() {
        if (!this.hasDetector() || this.isTextDisposed()) {
            return;
        }
        this.fStyledText.addMouseListener((MouseListener)this);
        this.fStyledText.addKeyListener((KeyListener)this);
    }

    protected boolean hasDetector() {
        return this.fDetector != null;
    }

    protected void removeListeners() {
        if (!this.hasDetector() || this.isTextDisposed()) {
            return;
        }
        this.fStyledText.removeMouseListener((MouseListener)this);
        this.fStyledText.removeKeyListener((KeyListener)this);
    }
}

