/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.outline;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QuickOutlineMouseMoveListener
implements MouseMoveListener {
    private TreeItem fLastItem = null;
    private TreeViewer fTreeViewer;

    public QuickOutlineMouseMoveListener(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    public void mouseMove(MouseEvent mouseEvent) {
        TreeItem treeItem;
        Tree tree = this.fTreeViewer.getTree();
        if (tree.equals(mouseEvent.getSource()) && (treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y))) instanceof TreeItem) {
            if (!treeItem.equals(this.fLastItem)) {
                this.fLastItem = treeItem;
                tree.setSelection(new TreeItem[]{this.fLastItem});
            } else if (mouseEvent.y < tree.getItemHeight() / 4) {
                Point point = tree.toDisplay(mouseEvent.x, mouseEvent.y);
                Item item = this.fTreeViewer.scrollUp(point.x, point.y);
                if (item instanceof TreeItem) {
                    this.fLastItem = (TreeItem)item;
                    tree.setSelection(new TreeItem[]{this.fLastItem});
                }
            } else if (mouseEvent.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                Point point = tree.toDisplay(mouseEvent.x, mouseEvent.y);
                Item item = this.fTreeViewer.scrollDown(point.x, point.y);
                if (item instanceof TreeItem) {
                    this.fLastItem = (TreeItem)item;
                    tree.setSelection(new TreeItem[]{this.fLastItem});
                }
            }
        }
    }
}

