/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.IReconcilingParticipant;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.outline.QuickOutlinePopupDialog;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.MTJSourceInfoProvider;
import org.eclipse.mtj.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.mtj.internal.ui.editor.text.SourceInformationProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class ChangeAwareSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private InformationPresenter fInfoPresenter;
    private InformationPresenter fOutlinePresenter;
    private MonoReconciler fReconciler;
    protected IColorManager fColorManager;
    protected MTJSourcePage sourcePage;

    public ChangeAwareSourceViewerConfiguration(MTJSourcePage mTJSourcePage, IColorManager iColorManager) {
        this(mTJSourcePage, iColorManager, (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{MTJUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
    }

    public ChangeAwareSourceViewerConfiguration(MTJSourcePage mTJSourcePage, IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        super(iPreferenceStore);
        this.fColorManager = iColorManager;
        this.sourcePage = mTJSourcePage;
    }

    public abstract void adaptToPreferenceChange(PropertyChangeEvent var1);

    public abstract boolean affectsColorPresentation(PropertyChangeEvent var1);

    public abstract boolean affectsTextPresentation(PropertyChangeEvent var1);

    public abstract void dispose();

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        IHyperlinkDetector[] iHyperlinkDetectorArray = super.getHyperlinkDetectors(iSourceViewer);
        if (iHyperlinkDetectorArray == null) {
            return null;
        }
        if (this.sourcePage == null) {
            return iHyperlinkDetectorArray;
        }
        IHyperlinkDetector iHyperlinkDetector = (IHyperlinkDetector)this.sourcePage.getAdapter(IHyperlinkDetector.class);
        if (iHyperlinkDetector == null) {
            return iHyperlinkDetectorArray;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray2 = new IHyperlinkDetector[iHyperlinkDetectorArray.length + 1];
        System.arraycopy(iHyperlinkDetectorArray, 0, iHyperlinkDetectorArray2, 0, iHyperlinkDetectorArray.length);
        iHyperlinkDetectorArray2[iHyperlinkDetectorArray.length] = iHyperlinkDetector;
        return iHyperlinkDetectorArray2;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer iSourceViewer) {
        if (this.sourcePage == null) {
            return null;
        }
        if (this.fInfoPresenter == null && this.getInfoImplementationType() != 0) {
            String[] stringArray;
            IInformationControlCreator iInformationControlCreator = this.getInformationControlCreator(false);
            this.fInfoPresenter = new InformationPresenter(iInformationControlCreator);
            this.fInfoPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            SourceInformationProvider sourceInformationProvider = new SourceInformationProvider(this.sourcePage, iInformationControlCreator, this.getInfoImplementationType());
            String[] stringArray2 = stringArray = this.getConfiguredContentTypes(iSourceViewer);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.fInfoPresenter.setInformationProvider((IInformationProvider)sourceInformationProvider, string);
                ++n2;
            }
            this.fInfoPresenter.setSizeConstraints(60, 10, true, true);
        }
        return this.fInfoPresenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer iSourceViewer) {
        String[] stringArray;
        if (this.sourcePage == null) {
            return null;
        }
        if (this.fOutlinePresenter != null) {
            return this.fOutlinePresenter;
        }
        this.fOutlinePresenter = new InformationPresenter(this.getOutlinePresenterControlCreator(iSourceViewer, "org.eclipse.mtj.ui.quickOutline"));
        this.fOutlinePresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        this.fOutlinePresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        MTJSourceInfoProvider mTJSourceInfoProvider = new MTJSourceInfoProvider(this.sourcePage);
        String[] stringArray2 = stringArray = this.getConfiguredContentTypes(iSourceViewer);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.fOutlinePresenter.setInformationProvider((IInformationProvider)mTJSourceInfoProvider, string);
            ++n2;
        }
        this.fOutlinePresenter.setSizeConstraints(50, 20, true, false);
        return this.fOutlinePresenter;
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        IBaseModel iBaseModel;
        if (this.sourcePage != null && this.fReconciler == null && (iBaseModel = this.sourcePage.getInputContext().getModel()) instanceof IReconcilingParticipant) {
            ReconcilingStrategy reconcilingStrategy = new ReconcilingStrategy();
            reconcilingStrategy.addParticipant((IReconcilingParticipant)iBaseModel);
            ISortableContentOutlinePage iSortableContentOutlinePage = this.sourcePage.getContentOutline();
            if (iSortableContentOutlinePage instanceof IReconcilingParticipant) {
                reconcilingStrategy.addParticipant((IReconcilingParticipant)iSortableContentOutlinePage);
            }
            this.fReconciler = new MonoReconciler((IReconcilingStrategy)reconcilingStrategy, false);
            this.fReconciler.setDelay(500);
        }
        return this.fReconciler;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer iSourceViewer, String string) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                QuickOutlinePopupDialog quickOutlinePopupDialog = new QuickOutlinePopupDialog(shell, n, ChangeAwareSourceViewerConfiguration.this.sourcePage, ChangeAwareSourceViewerConfiguration.this.sourcePage);
                return quickOutlinePopupDialog;
            }
        };
    }

    protected int getInfoImplementationType() {
        return 0;
    }

    protected IInformationControlCreator getInformationControlCreator(boolean bl) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell);
            }
        };
    }
}

