/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends CellEditor {
    private static final int defaultStyle = 4;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private boolean isSelection = false;
    private ModifyListener modifyListener;
    protected Text text;

    public TextCellEditor() {
        this.setStyle(4);
    }

    public TextCellEditor(Composite composite) {
        this(composite, 4);
    }

    public TextCellEditor(Composite composite, int n) {
        super(composite, n);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int n = this.text.getCaretPosition();
            if (n < this.text.getCharCount()) {
                this.text.setSelection(n, n + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    private void checkDeleteable() {
        boolean bl = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (bl != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean bl = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (bl != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean bl = this.isSelection;
        boolean bl2 = this.isSelection = this.text.getSelectionCount() > 0;
        if (bl != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    TextCellEditor.this.editOccured(modifyEvent);
                }
            };
        }
        return this.modifyListener;
    }

    protected Control createControl(Composite composite) {
        this.text = new Text(composite, this.getStyle());
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TextCellEditor.this.handleDefaultSelection(selectionEvent);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TextCellEditor.this.keyReleaseOccured(keyEvent);
                if (TextCellEditor.this.getControl() == null || TextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TextCellEditor.this.checkSelection();
                TextCellEditor.this.checkDeleteable();
                TextCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TextCellEditor.this.checkSelection();
                TextCellEditor.this.checkDeleteable();
                TextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TextCellEditor.this.focusLost();
            }
        });
        this.text.setFont(composite.getFont());
        this.text.setBackground(composite.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    protected boolean dependsOnExternalFocusListener() {
        return ((Object)((Object)this)).getClass() != TextCellEditor.class;
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object object) {
        Assert.isTrue((this.text != null && object instanceof String ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText((String)object);
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent modifyEvent) {
        String string = this.text.getText();
        if (string == null) {
            string = "";
        }
        String string2 = string;
        boolean bl = this.isValueValid();
        boolean bl2 = this.isCorrect(string2);
        if (!bl2) {
            this.setErrorMessage(NLS.bind((String)this.getErrorMessage(), (Object[])new Object[]{string}));
        }
        this.valueChanged(bl, bl2);
    }

    protected void handleDefaultSelection(SelectionEvent selectionEvent) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }
}

