/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.AbstractEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerError;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerManager;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "l10n-context";
    private L10nMarkerManager markerManager = new L10nMarkerManager();

    public L10nInputContext(MTJFormEditor mTJFormEditor, IEditorInput iEditorInput, boolean bl) {
        super(mTJFormEditor, iEditorInput, bl);
        this.create();
        this.updateMarkersFromModel((IFileEditorInput)super.getInput(), (L10nModel)this.getModel());
    }

    @Override
    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        AbstractEditingModel abstractEditingModel = (AbstractEditingModel)this.getModel();
        abstractEditingModel.reconciled(abstractEditingModel.getDocument());
    }

    @Override
    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        L10nModel l10nModel = (L10nModel)this.getModel();
        l10nModel.getLocales().validate();
        if (this.validateModel(l10nModel)) {
            return;
        }
        this.validateDefaultLocale(l10nModel);
    }

    private void validateDefaultLocale(L10nModel l10nModel) {
        int n = -1;
        String string = MTJUIMessages.L10nLocaleDetails_noDefaultLocale;
        if (l10nModel.getLocales().getDefaultLocale() == null) {
            n = l10nModel.getLocales().getLocalesLine() + 1;
            this.addWarningMarker((IFileEditorInput)super.getInput(), n, string);
        } else {
            this.cleanMarkers((IFileEditorInput)super.getInput(), 1);
        }
    }

    public boolean validateModel(L10nModel l10nModel) {
        Vector vector = l10nModel.getLocales().getMarkerErrors();
        this.cleanMarkers((IFileEditorInput)super.getInput(), 2);
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                this.updateMarkersFromLines((IFileEditorInput)super.getInput(), ((L10nMarkerError)vector.get(n)).getLine(), ((L10nMarkerError)vector.get(n)).getErrorMessage());
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    protected IBaseModel createModel(IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IStorageEditorInput) {
            boolean bl = iEditorInput instanceof IFileEditorInput;
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)iEditorInput);
            L10nModel l10nModel = new L10nModel(iDocument, bl);
            if (iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                l10nModel.setUnderlyingResource((IResource)iFile);
                l10nModel.setCharset(iFile.getCharset());
            } else if (iEditorInput instanceof SystemFileEditorInput) {
                File file = (File)((SystemFileEditorInput)iEditorInput).getAdapter(File.class);
                l10nModel.setInstallLocation(file.getParent());
                l10nModel.setCharset(this.getDefaultCharset());
            } else {
                l10nModel.setCharset(this.getDefaultCharset());
            }
            l10nModel.load();
            return l10nModel;
        }
        return null;
    }

    @Override
    protected String getDefaultCharset() {
        return "ISO-8859-1";
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected String getPartitionName() {
        return "___l10n_partition";
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> arrayList) {
    }

    private void updateMarkersFromModel(IFileEditorInput iFileEditorInput, L10nModel l10nModel) {
        try {
            this.markerManager.createMarker(iFileEditorInput.getFile(), l10nModel);
        }
        catch (CoreException coreException) {}
    }

    private void updateMarkersFromLines(IFileEditorInput iFileEditorInput, int n, String string) {
        try {
            this.markerManager.createMarker(iFileEditorInput.getFile(), n, string, false);
        }
        catch (CoreException coreException) {}
    }

    private void cleanMarkers(IFileEditorInput iFileEditorInput, int n) {
        try {
            this.markerManager.clearMarkers(iFileEditorInput.getFile(), n);
        }
        catch (CoreException coreException) {}
    }

    private void addWarningMarker(IFileEditorInput iFileEditorInput, int n, String string) {
        try {
            this.markerManager.addWarningMarker(iFileEditorInput.getFile(), n, string);
        }
        catch (CoreException coreException) {}
    }
}

