/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTypeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SELECT_MAIN_METHOD_DIALOG = "org.eclipse.jdt.debug.ui.select_main_method_dialog";
    private static final String SETTINGS_ID = "org.eclipse.mtj.ui.MIDLET_SELECTION_DIALOG";
    private IType[] fTypes = null;

    public DebugTypeSelectionDialog(Shell shell, IType[] iTypeArray, String string) {
        super(shell, false);
        this.setTitle(string);
        this.fTypes = iTypeArray;
        this.setMessage(MTJUIMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        this.setInitialPattern("**");
        this.setListLabelProvider(new DebugTypeLabelProvider());
        this.setDetailsLabelProvider(new DebugTypeDetailsLabelProvider());
        this.setSelectionHistory(new DebugTypeSelectionHistory());
    }

    public String getElementName(Object object) {
        if (object instanceof IType) {
            return ((IType)object).getElementName();
        }
        return null;
    }

    protected Control createDialogArea(Composite composite) {
        Control control = super.createDialogArea(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, SELECT_MAIN_METHOD_DIALOG);
        return control;
    }

    protected Control createExtendedContentArea(Composite composite) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new DebugTypeItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider abstractContentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fTypes != null && this.fTypes.length > 0) {
            IType[] iTypeArray = this.fTypes;
            int n = this.fTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                if (itemsFilter.isConsistentItem((Object)iType)) {
                    abstractContentProvider.add((Object)iType, itemsFilter);
                }
                ++n2;
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = MTJUIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(SETTINGS_ID);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(SETTINGS_ID);
        }
        return iDialogSettings2;
    }

    protected Comparator<IType> getItemsComparator() {
        Comparator<IType> comparator = new Comparator<IType>(){

            @Override
            public int compare(IType iType, IType iType2) {
                return iType.getElementName().compareTo(iType2.getElementName());
            }
        };
        return comparator;
    }

    protected IStatus validateItem(Object object) {
        return Status.OK_STATUS;
    }

    class DebugTypeDetailsLabelProvider
    extends DebugTypeLabelProvider {
        DebugTypeDetailsLabelProvider() {
        }

        public Image getImage(Object object) {
            if (object instanceof IType) {
                return super.getImage(this.getDeclaringContainer((IType)object));
            }
            return super.getImage(object);
        }

        public String getText(Object object) {
            IType iType;
            String string;
            if (object instanceof IType && (string = this.getDeclaringContainerName(iType = (IType)object)) != null) {
                if (string.equals(MTJUIMessages.MainMethodLabelProvider_0)) {
                    IJavaProject iJavaProject = iType.getJavaProject();
                    if (iJavaProject != null) {
                        try {
                            return String.valueOf(iJavaProject.getOutputLocation().toOSString().substring(1)) + " - " + string;
                        }
                        catch (JavaModelException javaModelException) {
                            MTJLogger.log((int)4, (Throwable)javaModelException);
                        }
                    }
                } else {
                    return string;
                }
            }
            return null;
        }
    }

    class DebugTypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        DebugTypeItemsFilter() {
            super((FilteredItemsSelectionDialog)DebugTypeSelectionDialog.this);
        }

        public boolean isConsistentItem(Object object) {
            return object instanceof IType;
        }

        public boolean matchItem(Object object) {
            if (!(object instanceof IType) || !Arrays.asList(DebugTypeSelectionDialog.this.fTypes).contains(object)) {
                return false;
            }
            return this.matches(((IType)object).getElementName());
        }
    }

    public class DebugTypeLabelProvider
    implements ILabelProvider {
        HashMap<ImageDescriptor, Image> fImageMap = new HashMap();

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
            this.fImageMap.clear();
            this.fImageMap = null;
        }

        public Image getImage(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class)) != null) {
                ImageDescriptor imageDescriptor = iWorkbenchAdapter.getImageDescriptor(object);
                Image image = this.fImageMap.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.fImageMap.put(imageDescriptor, image);
                }
                return image;
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof IType) {
                IType iType = (IType)object;
                String string = iType.getElementName();
                String string2 = this.getDeclaringContainerName(iType);
                if (string2 != null && !"".equals(string2)) {
                    string = String.valueOf(string) + " - " + string2;
                }
                return string;
            }
            return null;
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        protected IJavaElement getDeclaringContainer(IType iType) {
            IType iType2 = iType.getDeclaringType();
            if (iType2 == null) {
                iType2 = iType.getPackageFragment();
            }
            return iType2;
        }

        protected String getDeclaringContainerName(IType iType) {
            IType iType2 = iType.getDeclaringType();
            if (iType2 != null) {
                return iType2.getFullyQualifiedName('.');
            }
            String string = iType.getPackageFragment().getElementName();
            if ("".equals(string)) {
                string = MTJUIMessages.MainMethodLabelProvider_0;
            }
            return string;
        }
    }

    class DebugTypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        DebugTypeSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento iMemento) {
            IJavaElement iJavaElement = JavaCore.create((String)iMemento.getTextData());
            return iJavaElement instanceof IType ? iJavaElement : null;
        }

        protected void storeItemToMemento(Object object, IMemento iMemento) {
            if (object instanceof IType) {
                iMemento.putTextData(((IType)object).getHandleIdentifier());
            }
        }
    }
}

