/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;

public class ManifestPreferenceStore
implements IManifestPreferenceStore {
    private boolean dirty;
    private String filename;
    private PreferenceStore wrappedPrefStore;

    public ManifestPreferenceStore() {
        this(null);
    }

    public ManifestPreferenceStore(String string) {
        this.filename = string;
        this.wrappedPrefStore = new PreferenceStore();
        this.dirty = false;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.wrappedPrefStore.addPropertyChangeListener(iPropertyChangeListener);
    }

    public boolean contains(String string) {
        return this.wrappedPrefStore.contains(string);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        this.wrappedPrefStore.firePropertyChangeEvent(string, object, object2);
    }

    public boolean getBoolean(String string) {
        return this.wrappedPrefStore.getBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        return this.wrappedPrefStore.getDefaultBoolean(string);
    }

    public double getDefaultDouble(String string) {
        return this.wrappedPrefStore.getDefaultDouble(string);
    }

    public float getDefaultFloat(String string) {
        return this.wrappedPrefStore.getDefaultFloat(string);
    }

    public int getDefaultInt(String string) {
        return this.wrappedPrefStore.getDefaultInt(string);
    }

    public long getDefaultLong(String string) {
        return this.wrappedPrefStore.getDefaultLong(string);
    }

    public String getDefaultString(String string) {
        return this.wrappedPrefStore.getDefaultString(string);
    }

    public double getDouble(String string) {
        return this.wrappedPrefStore.getDouble(string);
    }

    public float getFloat(String string) {
        return this.wrappedPrefStore.getFloat(string);
    }

    public int getInt(String string) {
        return this.wrappedPrefStore.getInt(string);
    }

    public long getLong(String string) {
        return this.wrappedPrefStore.getLong(string);
    }

    public String getString(String string) {
        return this.wrappedPrefStore.getString(string);
    }

    public boolean isDefault(String string) {
        return this.wrappedPrefStore.isDefault(string);
    }

    public void load() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        FileInputStream fileInputStream = new FileInputStream(this.filename);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public void load(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(58);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            this.setValue(string2, string3);
        }
        this.dirty = false;
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        return this.wrappedPrefStore.preferenceNames();
    }

    public void putValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.wrappedPrefStore.putValue(string, string2);
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.wrappedPrefStore.removePropertyChangeListener(iPropertyChangeListener);
    }

    public void save() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.filename);
            this.save(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        String[] stringArray = this.preferenceNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.getString(string);
            if (string2.trim().length() > 0) {
                printWriter.println(String.valueOf(string) + ": " + string2);
            }
            ++n;
        }
        printWriter.flush();
        this.dirty = false;
    }

    public void setDefault(String string, double d) {
        this.wrappedPrefStore.setDefault(string, d);
    }

    public void setDefault(String string, float f) {
        this.wrappedPrefStore.setDefault(string, f);
    }

    public void setDefault(String string, int n) {
        this.wrappedPrefStore.setDefault(string, n);
    }

    public void setDefault(String string, long l) {
        this.wrappedPrefStore.setDefault(string, l);
    }

    public void setDefault(String string, String string2) {
        this.wrappedPrefStore.setDefault(string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.wrappedPrefStore.setDefault(string, bl);
    }

    public void setToDefault(String string) {
        this.dirty = true;
        this.wrappedPrefStore.setToDefault(string);
    }

    public void setValue(String string, double d) {
        double d2 = this.getDouble(string);
        if (d != d2) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(string, d);
        }
    }

    public void setValue(String string, float f) {
        float f2 = this.getFloat(string);
        if (f != f2) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(string, f);
        }
    }

    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n != n2) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(string, n);
        }
    }

    public void setValue(String string, long l) {
        long l2 = this.getLong(string);
        if (l != l2) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(string, l);
        }
    }

    public void setValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string2 != string3) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(string, string2);
        }
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl != bl2) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(string, bl);
        }
    }
}

