/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.midlet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.ApplicationDescriptor;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateBuilderException;
import org.eclipse.mtj.internal.ui.templates.midlets.MidletTemplateBuilder;
import org.eclipse.mtj.internal.ui.wizards.midlet.page.NewMidletWizardPage;
import org.eclipse.mtj.internal.ui.wizards.templates.TemplateWizardPageDelegate;
import org.eclipse.mtj.internal.ui.wizards.templates.midlets.MidletTemplateListWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletWizard
extends Wizard
implements INewWizard {
    public static final String TemplateCustomPage = "TemplateCustomPage";
    private NewMidletWizardPage midletPage;
    private IStructuredSelection selection;
    private MidletTemplateListWizardPage page1;
    private TemplateWizardPageDelegate page2;
    private IWorkbench workbench;

    public NewMidletWizard() {
        this.setWindowTitle(MTJUIMessages.NewMidletWizard_dialogtitle);
        this.setDialogSettings(MTJUIPlugin.getDialogSettings("NewMidletWizard"));
        this.setDefaultPageImageDescriptor(MTJUIPluginImages.DESC_NEW_MIDLET_CLASS);
    }

    public void addPages() {
        this.midletPage = new NewMidletWizardPage();
        this.addPage((IWizardPage)this.midletPage);
        this.midletPage.setWizard((IWizard)this);
        this.midletPage.init(this.selection);
        this.page1 = new MidletTemplateListWizardPage();
        this.page1.setImageDescriptor(MTJUIPluginImages.DESC_TEMPLATE_WIZ);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new TemplateWizardPageDelegate(TemplateCustomPage);
        this.page2.setImageDescriptor(MTJUIPluginImages.DESC_TEMPLATE_WIZ);
        this.addPage((IWizardPage)this.page2);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        boolean bl = true;
        IRunnableWithProgress iRunnableWithProgress = this.getCreateMidletOperation();
        try {
            this.getContainer().run(false, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MTJUIPlugin.getPluginId(), "error creating the new MIDlet", (Throwable)invocationTargetException));
            bl = false;
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    private void addMidletToJAD(IType iType, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        IJavaProject iJavaProject = (IJavaProject)iType.getAncestor(2);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        IApplicationDescriptor iApplicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
        if (iApplicationDescriptor != null) {
            ApplicationDescriptor.MidletDefinition midletDefinition = new ApplicationDescriptor.MidletDefinition(iApplicationDescriptor.getMidletCount() + 1, iType.getElementName(), "", iType.getFullyQualifiedName());
            iApplicationDescriptor.addMidletDefinition((IMidletDefinition)midletDefinition);
            iApplicationDescriptor.store();
            IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
            iFile.refreshLocal(1, iProgressMonitor);
        }
    }

    private IRunnableWithProgress getCreateMidletOperation() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Object object;
                IType iType = null;
                if (NewMidletWizard.this.page1.getSelectedTemplate() != null) {
                    object = new MidletTemplateBuilder(NewMidletWizard.this.page1.getSelectedTemplate(), NewMidletWizard.this.page2.getDictionary());
                    try {
                        iType = ((MidletTemplateBuilder)object).build(NewMidletWizard.this.midletPage.getPackageFragmentRoot(), NewMidletWizard.this.midletPage.getPackageText(), NewMidletWizard.this.midletPage.getTypeName());
                    }
                    catch (MIDletTemplateBuilderException mIDletTemplateBuilderException) {
                        MTJLogger.log((int)4, (Throwable)mIDletTemplateBuilderException);
                    }
                } else {
                    object = new WorkspaceModifyDelegatingOperation(NewMidletWizard.this.midletPage.getRunnable());
                    object.run(iProgressMonitor);
                    iType = NewMidletWizard.this.midletPage.getCreatedType();
                }
                if (iType != null) {
                    object = iType.getResource();
                    if (object != null) {
                        BasicNewResourceWizard.selectAndReveal((IResource)object, (IWorkbenchWindow)NewMidletWizard.this.workbench.getActiveWorkbenchWindow());
                        NewMidletWizard.this.openResource((IFile)object);
                    }
                    if (NewMidletWizard.this.midletPage.isAddToJadSelected()) {
                        try {
                            NewMidletWizard.this.addMidletToJAD(iType, iProgressMonitor);
                        }
                        catch (IOException iOException) {
                            throw new InvocationTargetException(iOException);
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                    }
                }
            }
        };
        return new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
    }

    private void openResource(final IFile iFile) {
        Display display;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = this.workbench.getActiveWorkbenchWindow().getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        partInitException.printStackTrace();
                    }
                }
            });
        }
    }
}

