/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mtj.internal.jmunit.ui.part.MethodStubsSelectionButtonGroup;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static Control createEmptySpace(Composite composite, int n) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        gridData.horizontalIndent = 0;
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static void doDefaultLayout(Composite composite, MethodStubsSelectionButtonGroup[] methodStubsSelectionButtonGroupArray, boolean bl) {
        LayoutUtil.doDefaultLayout(composite, methodStubsSelectionButtonGroupArray, bl, 0, 0, 0, 0);
    }

    public static void doDefaultLayout(Composite composite, MethodStubsSelectionButtonGroup[] methodStubsSelectionButtonGroupArray, boolean bl, int n, int n2) {
        LayoutUtil.doDefaultLayout(composite, methodStubsSelectionButtonGroupArray, bl, n, n2, 0, 0);
    }

    public static void doDefaultLayout(Composite composite, MethodStubsSelectionButtonGroup[] methodStubsSelectionButtonGroupArray, boolean bl, int n, int n2, int n3, int n4) {
        int n5 = LayoutUtil.getNumberOfColumns(methodStubsSelectionButtonGroupArray);
        Control[][] controlArrayArray = new Control[methodStubsSelectionButtonGroupArray.length][];
        int n6 = 0;
        while (n6 < methodStubsSelectionButtonGroupArray.length) {
            controlArrayArray[n6] = methodStubsSelectionButtonGroupArray[n6].doFillIntoGrid(composite, n5);
            ++n6;
        }
        if (bl) {
            LayoutUtil.modifyLabelSpans(controlArrayArray, --n5);
        }
        GridLayout gridLayout = new GridLayout();
        if (n3 != -1) {
            gridLayout.marginWidth = n3;
        }
        if (n4 != -1) {
            gridLayout.marginHeight = n4;
        }
        gridLayout.numColumns = n5;
        composite.setLayout((Layout)gridLayout);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)button);
        int n = pixelConverter.convertHorizontalDLUsToPixels(61);
        return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getNumberOfColumns(MethodStubsSelectionButtonGroup[] methodStubsSelectionButtonGroupArray) {
        int n = 0;
        MethodStubsSelectionButtonGroup[] methodStubsSelectionButtonGroupArray2 = methodStubsSelectionButtonGroupArray;
        int n2 = methodStubsSelectionButtonGroupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MethodStubsSelectionButtonGroup methodStubsSelectionButtonGroup = methodStubsSelectionButtonGroupArray2[n3];
            n = Math.max(methodStubsSelectionButtonGroup.getNumberOfControls(), n);
            ++n3;
        }
        return n;
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object object = button.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = LayoutUtil.getButtonWidthHint(button);
            ((GridData)object).horizontalAlignment = 4;
        }
    }

    public static void setHorizontalIndent(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalIndent = n;
        }
    }

    public static void setHorizontalSpan(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalSpan = n;
        } else if (n != 1) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = n;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setWidthHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = n;
        }
    }

    private static void modifyLabelSpans(Control[][] controlArray, int n) {
        Control[][] controlArray2 = controlArray;
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Control[] controlArray3 = controlArray2[n3];
            LayoutUtil.setHorizontalSpan(controlArray3[0], n);
            ++n3;
        }
    }
}

