/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp.ota;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.Utils;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTAHandler
extends AbstractHandler {
    private static final String OTA_CONTEXT_PATH = "/ota";
    private static final String[] KNOWN_MIME_TYPES = new String[]{"jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive"};
    private static Map<String, String> mimeTypeMap;
    private static final long serialVersionUID = 1L;

    private static Map<String, String> getMimeTypeMap() {
        if (mimeTypeMap == null) {
            mimeTypeMap = new HashMap<String, String>();
            int n = 0;
            while (n < KNOWN_MIME_TYPES.length) {
                mimeTypeMap.put(KNOWN_MIME_TYPES[n++], KNOWN_MIME_TYPES[n++]);
            }
        }
        return mimeTypeMap;
    }

    public void handle(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) throws ServletException, IOException {
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string2 != null && string3 != null) {
            try {
                this.handle(string2, string3, string, httpServletRequest, httpServletResponse);
            }
            catch (CoreException coreException) {
                throw new IOException(coreException.getMessage());
            }
        }
    }

    private String getContentEncoding(IFile iFile) {
        return iFile.getFileExtension().equals("jad") ? "UTF-8" : null;
    }

    private String getContentType(IFile iFile) {
        String string = OTAHandler.getMimeTypeMap().get(iFile.getFileExtension());
        return string != null ? string : "application/octet-stream";
    }

    private IJavaProject getJavaProject(String string) {
        IJavaProject iJavaProject = null;
        IWorkspaceRoot iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject != null) {
            iJavaProject = JavaCore.create((IProject)iProject);
        }
        return iJavaProject;
    }

    private void handle(IJavaProject iJavaProject, String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws CoreException, IOException {
        IFile iFile;
        String string3 = ".mtj.tmp" + File.separator + "emulation";
        IFolder iFolder = iJavaProject.getProject().getFolder(string3);
        if (iFolder.exists() && (iFile = iFolder.getFile(string)).exists()) {
            this.sendFile(iFile, httpServletResponse);
        }
    }

    private void handle(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws CoreException, IOException {
        IJavaProject iJavaProject = this.getJavaProject(string);
        if (iJavaProject != null) {
            this.handle(iJavaProject, string2, string3, httpServletRequest, httpServletResponse);
        }
    }

    private void sendFile(IFile iFile, HttpServletResponse httpServletResponse) throws CoreException, IOException {
        String string = this.getContentType(iFile);
        String string2 = this.getContentEncoding(iFile);
        File file = iFile.getLocation().toFile();
        httpServletResponse.setCharacterEncoding(string2);
        httpServletResponse.setContentType(string);
        httpServletResponse.setContentLength((int)file.length());
        InputStream inputStream = iFile.getContents();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        Utils.copyInputToOutput(inputStream, (OutputStream)servletOutputStream);
        servletOutputStream.close();
        inputStream.close();
        httpServletResponse.flushBuffer();
    }

    static ContextHandler getContextHandler() {
        ContextHandler contextHandler = new ContextHandler(OTA_CONTEXT_PATH);
        contextHandler.setHandler((Handler)new OTAHandler());
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.setMimeMap(OTAHandler.getMimeTypeMap());
        contextHandler.setMimeTypes(mimeTypes);
        return contextHandler;
    }
}

