/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp.ota;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.midp.ota.OTAHandler;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;

public class OTAServer {
    private static OTAServer instance;
    private Server httpServer;
    private Server server = this.getHttpServer();

    public static synchronized OTAServer getInstance() {
        if (instance == null) {
            instance = new OTAServer();
        }
        return instance;
    }

    public static synchronized int getPort() {
        Connector connector = OTAServer.getInstance().getHttpServer().getConnectors()[0];
        return connector.getLocalPort();
    }

    private OTAServer() {
    }

    public synchronized void start() throws Exception {
        if (this.server != null && !this.server.isStarted()) {
            this.server.start();
        }
    }

    public synchronized void stop() throws Exception {
        if (this.server != null && this.server.isStarted()) {
            this.server.stop();
        }
    }

    private String getLogFileName() {
        IPath iPath = MTJCore.getMTJCore().getStateLocation();
        IPath iPath2 = iPath.append("jetty");
        File file = iPath2.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, "logfile");
        String string = file2 + "yyyy_mm_dd.txt";
        return string;
    }

    private Server createHttpServer() {
        Server server = new Server();
        server.setConnectors(this.getConnectors());
        server.addHandler((Handler)OTAHandler.getContextHandler());
        NCSARequestLog nCSARequestLog = new NCSARequestLog(this.getLogFileName());
        server.addLifeCycle((LifeCycle)nCSARequestLog);
        return server;
    }

    private Connector[] getConnectors() {
        int n;
        SocketConnector socketConnector = new SocketConnector();
        if (Platform.getPreferencesService().getBoolean(MTJCore.getPluginId(), "ota_port_defined", false, null) && (n = Platform.getPreferencesService().getInt(MTJCore.getPluginId(), "ota_port", 0, null)) != 0) {
            socketConnector.setPort(n);
        }
        return new Connector[]{socketConnector};
    }

    private Server getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = this.createHttpServer();
        }
        return this.httpServer;
    }
}

