/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.packaging.midp;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.sign.SignatureUtils;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class DeployedJADWriter {
    private IMidletSuiteProject midletSuite;
    private IFolder deploymentFolder;
    private File deployedJarFile;

    public DeployedJADWriter(IMidletSuiteProject iMidletSuiteProject, IFolder iFolder, File file) {
        this.midletSuite = iMidletSuiteProject;
        this.deploymentFolder = iFolder;
        this.deployedJarFile = file;
    }

    public void writeDeployedJAD(boolean bl, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        IJadSignature iJadSignature;
        IApplicationDescriptor iApplicationDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = (ColonDelimitedProperties)iApplicationDescriptor.getManifestProperties();
        colonDelimitedProperties.setProperty("MIDlet-Jar-Size", Long.valueOf(this.deployedJarFile.length()).toString());
        if (bl) {
            colonDelimitedProperties.setProperty("MIDlet-Jar-URL", this.deployedJarFile.getName());
        }
        this.writeJad(iApplicationDescriptor);
        if (!bl && (iJadSignature = SignatureUtils.getSignatureObject(this.midletSuite)) != null) {
            BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(this.midletSuite);
            buildStateMachine.changeState(MTJBuildState.PRE_SIGNING, iProgressMonitor);
            this.signJad(iJadSignature, this.deployedJarFile, colonDelimitedProperties);
            this.writeJad(iApplicationDescriptor);
            buildStateMachine.changeState(MTJBuildState.POST_SIGNING, iProgressMonitor);
        }
    }

    private void signJad(IJadSignature iJadSignature, File file, ColonDelimitedProperties colonDelimitedProperties) throws CoreException {
        iJadSignature.computeSignature(file);
        colonDelimitedProperties.setProperty("MIDlet-Jar-RSA-SHA1", iJadSignature.getJarSignatureString());
        String[] stringArray = iJadSignature.getCertificateStrings();
        int n = 1;
        while (n <= stringArray.length) {
            colonDelimitedProperties.setProperty("MIDlet-Certificate-1-" + n, stringArray[n - 1]);
            ++n;
        }
    }

    private void writeJad(IApplicationDescriptor iApplicationDescriptor) throws IOException {
        String string = this.midletSuite.getJadFileName();
        if (string != null) {
            IFile iFile = this.deploymentFolder.getFile(string);
            iApplicationDescriptor.store(iFile.getLocation().toFile());
        } else {
            MTJLogger.log(4, Messages.DeployedJADWriter_unableToResolveJadName);
        }
    }
}

