/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class MidletSuiteFactory {
    private static final Map<IJavaProject, IMidletSuiteProject> midletSuiteMap = new HashMap<IJavaProject, IMidletSuiteProject>();

    static {
        MTJCore.getDeviceRegistry().addRegistryListener(new DeviceRegistryListener());
    }

    public static MidletSuiteCreationRunnable getMidletSuiteCreationRunnable(IProject iProject, IJavaProject iJavaProject, IMIDPDevice iMIDPDevice, String string) {
        return new MidletSuiteCreationRunnable(iProject, iJavaProject, iMIDPDevice, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMidletSuiteProject getMidletSuiteProject(IJavaProject iJavaProject) {
        IMidletSuiteProject iMidletSuiteProject = null;
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            iMidletSuiteProject = midletSuiteMap.get(iJavaProject);
            if (iMidletSuiteProject == null) {
                iMidletSuiteProject = new MidletSuiteProject(iJavaProject);
                midletSuiteMap.put(iJavaProject, iMidletSuiteProject);
            }
        }
        return iMidletSuiteProject;
    }

    public static IMTJProject getMidletSuiteProject(String string) {
        IMidletSuiteProject iMidletSuiteProject = null;
        try {
            IProject iProject;
            if (string != null && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)).exists() && iProject.hasNature("org.eclipse.mtj.core.nature")) {
                iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)iProject));
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        return iMidletSuiteProject;
    }

    public static boolean isMidletSuiteProject(IProject iProject) {
        if (iProject == null) {
            return false;
        }
        IMTJProject iMTJProject = MidletSuiteFactory.getMidletSuiteProject(iProject.getName());
        return iMTJProject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidletSuiteProject(IJavaProject iJavaProject) {
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            midletSuiteMap.remove(iJavaProject);
        }
    }

    private MidletSuiteFactory() {
    }

    public static class DeviceRegistryListener
    implements IDeviceRegistryListener {
        public void deviceAdded(IDevice iDevice) {
            for (IMTJProject iMTJProject : midletSuiteMap.values()) {
                MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
                for (MTJRuntime mTJRuntime : mTJRuntimeList) {
                    IDevice iDevice2 = mTJRuntime.getDevice();
                    if (iDevice2 == null || !iDevice2.getIdentifier().equals(iDevice.getIdentifier())) continue;
                    mTJRuntime.setDevice(iDevice);
                    if (!mTJRuntime.isActive()) continue;
                    try {
                        iMTJProject.refreshClasspath((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        MTJLogger.log(4, coreException);
                    }
                }
            }
        }

        public void deviceRemoved(IDevice iDevice) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MidletSuiteCreationRunnable {
        private static final String BIN_FOLDER_NAME = "bin";
        private IMIDPDevice device;
        private String jadFileName;
        private IJavaProject javaProject;
        private boolean preprocessingEnable;
        private IProject project;
        private Map<String, String> properties;
        private boolean localizationEnable;
        private String propertiesFolderName;
        private String packageName;
        private boolean jmUnitSupportEnable;

        private MidletSuiteCreationRunnable(IProject iProject, IJavaProject iJavaProject, IMIDPDevice iMIDPDevice, String string) {
            this.project = iProject;
            this.javaProject = iJavaProject;
            this.device = iMIDPDevice;
            this.jadFileName = string;
        }

        public boolean isPreprocessingEnable() {
            return this.preprocessingEnable;
        }

        public boolean isLocalizationEnable() {
            return this.localizationEnable;
        }

        public boolean isJMUnitSupportEnable() {
            return this.jmUnitSupportEnable;
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            try {
                IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
                this.createL10nData(iMidletSuiteProject, iProgressMonitor);
                iMidletSuiteProject.setJadFileName(this.jadFileName);
                this.addNatures(iProgressMonitor);
                this.setJavaProjectOptions(iProgressMonitor);
                this.setProjectMetadata();
                this.createApplicationDescriptorInProject(iProgressMonitor);
                this.setDeviceIntoActiveConfig(iMidletSuiteProject, this.device);
                iMidletSuiteProject.saveMetaData();
                iMidletSuiteProject.refreshClasspath(iProgressMonitor);
                IJavaProject iJavaProject = iMidletSuiteProject.getJavaProject();
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                    System.out.println(iClasspathEntry.getPath().toString());
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
            catch (IOException iOException) {
                throw new InvocationTargetException(iOException);
            }
        }

        private void createL10nData(IMidletSuiteProject iMidletSuiteProject, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
            IProject iProject = iMidletSuiteProject.getProject();
            if (this.localizationEnable) {
                IFolder iFolder = iProject.getFolder(this.propertiesFolderName);
                if (!iFolder.exists()) {
                    iFolder.create(true, true, iProgressMonitor);
                }
                iProject.refreshLocal(1, iProgressMonitor);
                ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
                arrayList.addAll(Arrays.asList(this.javaProject.getRawClasspath()));
                IClasspathEntry[] iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                if (!this.javaProject.hasClasspathCycle(iClasspathEntryArray)) {
                    this.javaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
                }
                IResource[] iResourceArray = Utils.getSourceFolders(this.javaProject);
                int n = 0;
                while (n < iResourceArray.length) {
                    IPackageFragmentRoot iPackageFragmentRoot = this.javaProject.getPackageFragmentRoot(iResourceArray[n]);
                    if (iPackageFragmentRoot.exists()) {
                        IPackageFragment iPackageFragment = iPackageFragmentRoot.createPackageFragment(this.packageName, true, iProgressMonitor);
                        L10nApi.createLocalizationFile(iProject, iFolder.getProjectRelativePath(), (IJavaElement)iPackageFragment);
                        this.javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        L10nApi.createLocalizationApi(iProject, iPackageFragment, iFolder.getProjectRelativePath());
                        this.javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    ++n;
                }
            }
        }

        public void setPreprocessingEnable(boolean bl) {
            this.preprocessingEnable = bl;
        }

        public void setLocalizationEnabled(boolean bl) {
            this.localizationEnable = bl;
        }

        public void setJMUnitSupport(boolean bl) {
            this.jmUnitSupportEnable = bl;
        }

        private boolean addNatureIfNecessary(ArrayList<String> arrayList, String string) {
            boolean bl = false;
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                bl = true;
            }
            return bl;
        }

        private void addNatures(IProgressMonitor iProgressMonitor) throws CoreException {
            IProjectDescription iProjectDescription = this.project.getDescription();
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(iProjectDescription.getNatureIds()));
            boolean bl = this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.nature");
            bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.jdt.core.javanature");
            if (this.isPreprocessingEnable()) {
                bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.preprocessingNature");
            }
            if (this.isLocalizationEnable()) {
                bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.core.l10nNature");
            }
            if (this.isJMUnitSupportEnable()) {
                bl |= this.addNatureIfNecessary(arrayList, "org.eclipse.mtj.jmunit.jmunitNature");
            }
            if (bl) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                iProjectDescription.setNatureIds(arrayList.toArray(new String[arrayList.size()]));
                this.project.setDescription(iProjectDescription, (IProgressMonitor)subProgressMonitor);
            }
        }

        private void setDeviceIntoActiveConfig(IMidletSuiteProject iMidletSuiteProject, IDevice iDevice) {
            MTJRuntimeList mTJRuntimeList = iMidletSuiteProject.getRuntimeList();
            MTJRuntime mTJRuntime = mTJRuntimeList.getActiveMTJRuntime();
            if (mTJRuntime != null) {
                mTJRuntime.setDevice(iDevice);
                return;
            }
            if (mTJRuntime == null && !mTJRuntimeList.isEmpty()) {
                mTJRuntime = (MTJRuntime)mTJRuntimeList.get(0);
            }
            if (mTJRuntime == null) {
                mTJRuntime = new MTJRuntime(iDevice.getName());
                mTJRuntime.setSymbolSet(iDevice.getSymbolSet());
            }
            mTJRuntime.setActive(true);
            mTJRuntime.setDevice(iDevice);
            mTJRuntimeList.add(mTJRuntime);
        }

        private void createApplicationDescriptorInProject(IProgressMonitor iProgressMonitor) throws CoreException, IOException {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
            if (!iFile.exists()) {
                InputStream inputStream = this.getJADFileSource(iMidletSuiteProject);
                iFile.create(inputStream, true, iProgressMonitor);
            }
        }

        private ColonDelimitedProperties getDefaultApplicationDescriptorProperties(IMidletSuiteProject iMidletSuiteProject) {
            ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
            colonDelimitedProperties.setProperty("MIDlet-Jar-URL", iMidletSuiteProject.getJarFilename());
            colonDelimitedProperties.setProperty("MIDlet-Name", this.properties.get("MIDlet-Name"));
            colonDelimitedProperties.setProperty("MIDlet-Vendor", this.properties.get("MIDlet-Vendor"));
            colonDelimitedProperties.setProperty("MIDlet-Version", this.properties.get("MIDlet-Version"));
            colonDelimitedProperties.setProperty("MicroEdition-Configuration", this.properties.get("MicroEdition-Configuration"));
            colonDelimitedProperties.setProperty("MicroEdition-Profile", this.properties.get("MicroEdition-Profile"));
            return colonDelimitedProperties;
        }

        private InputStream getJADFileSource(IMidletSuiteProject iMidletSuiteProject) throws IOException, CoreException {
            Object object;
            InputStream inputStream = null;
            String string = iMidletSuiteProject.getJadFileName();
            IFolder iFolder = this.project.getFolder(BIN_FOLDER_NAME);
            if (iFolder.exists() && (object = iFolder.getFile(string)).exists()) {
                inputStream = object.getContents();
            }
            if (inputStream == null) {
                object = new ByteArrayOutputStream();
                ColonDelimitedProperties colonDelimitedProperties = this.getDefaultApplicationDescriptorProperties(iMidletSuiteProject);
                colonDelimitedProperties.store((OutputStream)object, "");
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
            return inputStream;
        }

        private void setJavaProjectOptions(IProgressMonitor iProgressMonitor) {
            boolean bl = PreferenceAccessor.instance.getBoolean("force_java11");
            if (bl) {
                Map map = this.javaProject.getOptions(true);
                JavaCore.setComplianceOptions((String)"1.3", (Map)map);
                this.javaProject.setOptions(map);
            }
        }

        private void setProjectMetadata() throws CoreException {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            iMidletSuiteProject.saveMetaData();
        }

        public void setProperties(Map<String, String> map) {
            this.properties = map;
        }

        public void setPropertiesFolderName(String string) {
            this.propertiesFolderName = string;
        }

        public void setPackageName(String string) {
            this.packageName = string;
        }
    }
}

